/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.BulkUploadObjectType;
import com.kaltura.client.enums.BulkUploadType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.BulkUploadObjectData;
import com.kaltura.client.types.JobData;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class BulkUploadJobData
extends JobData {
    private String userId;
    private String uploadedBy;
    private Integer conversionProfileId;
    private String resultsFileLocalPath;
    private String resultsFileUrl;
    private Integer numOfEntries;
    private Integer numOfObjects;
    private String filePath;
    private BulkUploadObjectType bulkUploadObjectType;
    private String fileName;
    private BulkUploadObjectData objectData;
    private BulkUploadType type;
    private String emailRecipients;
    private Integer numOfErrorObjects;
    private String privileges;

    public String getUserId() {
        return this.userId;
    }

    public String getUploadedBy() {
        return this.uploadedBy;
    }

    public Integer getConversionProfileId() {
        return this.conversionProfileId;
    }

    public String getResultsFileLocalPath() {
        return this.resultsFileLocalPath;
    }

    public String getResultsFileUrl() {
        return this.resultsFileUrl;
    }

    public Integer getNumOfEntries() {
        return this.numOfEntries;
    }

    public Integer getNumOfObjects() {
        return this.numOfObjects;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public BulkUploadObjectType getBulkUploadObjectType() {
        return this.bulkUploadObjectType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void fileName(String multirequestToken) {
        this.setToken("fileName", multirequestToken);
    }

    public BulkUploadObjectData getObjectData() {
        return this.objectData;
    }

    public BulkUploadType getType() {
        return this.type;
    }

    public String getEmailRecipients() {
        return this.emailRecipients;
    }

    public void setEmailRecipients(String emailRecipients) {
        this.emailRecipients = emailRecipients;
    }

    public void emailRecipients(String multirequestToken) {
        this.setToken("emailRecipients", multirequestToken);
    }

    public Integer getNumOfErrorObjects() {
        return this.numOfErrorObjects;
    }

    public void setNumOfErrorObjects(Integer numOfErrorObjects) {
        this.numOfErrorObjects = numOfErrorObjects;
    }

    public void numOfErrorObjects(String multirequestToken) {
        this.setToken("numOfErrorObjects", multirequestToken);
    }

    public String getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(String privileges) {
        this.privileges = privileges;
    }

    public void privileges(String multirequestToken) {
        this.setToken("privileges", multirequestToken);
    }

    public BulkUploadJobData() {
    }

    public BulkUploadJobData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.userId = GsonParser.parseString(jsonObject.get("userId"));
        this.uploadedBy = GsonParser.parseString(jsonObject.get("uploadedBy"));
        this.conversionProfileId = GsonParser.parseInt(jsonObject.get("conversionProfileId"));
        this.resultsFileLocalPath = GsonParser.parseString(jsonObject.get("resultsFileLocalPath"));
        this.resultsFileUrl = GsonParser.parseString(jsonObject.get("resultsFileUrl"));
        this.numOfEntries = GsonParser.parseInt(jsonObject.get("numOfEntries"));
        this.numOfObjects = GsonParser.parseInt(jsonObject.get("numOfObjects"));
        this.filePath = GsonParser.parseString(jsonObject.get("filePath"));
        this.bulkUploadObjectType = BulkUploadObjectType.get(GsonParser.parseString(jsonObject.get("bulkUploadObjectType")));
        this.fileName = GsonParser.parseString(jsonObject.get("fileName"));
        this.objectData = GsonParser.parseObject(jsonObject.getAsJsonObject("objectData"), BulkUploadObjectData.class);
        this.type = BulkUploadType.get(GsonParser.parseString(jsonObject.get("type")));
        this.emailRecipients = GsonParser.parseString(jsonObject.get("emailRecipients"));
        this.numOfErrorObjects = GsonParser.parseInt(jsonObject.get("numOfErrorObjects"));
        this.privileges = GsonParser.parseString(jsonObject.get("privileges"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaBulkUploadJobData");
        kparams.add("fileName", this.fileName);
        kparams.add("emailRecipients", this.emailRecipients);
        kparams.add("numOfErrorObjects", this.numOfErrorObjects);
        kparams.add("privileges", this.privileges);
        return kparams;
    }

    public static interface Tokenizer
    extends JobData.Tokenizer {
        public String userId();

        public String uploadedBy();

        public String conversionProfileId();

        public String resultsFileLocalPath();

        public String resultsFileUrl();

        public String numOfEntries();

        public String numOfObjects();

        public String filePath();

        public String bulkUploadObjectType();

        public String fileName();

        public BulkUploadObjectData.Tokenizer objectData();

        public String type();

        public String emailRecipients();

        public String numOfErrorObjects();

        public String privileges();
    }
}

