/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.BatchJobErrorTypes;
import com.kaltura.client.enums.BatchJobStatus;
import com.kaltura.client.enums.BulkUploadObjectType;
import com.kaltura.client.enums.BulkUploadType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.BulkUploadResult;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class BulkUpload
extends ObjectBase {
    private Long id;
    private String uploadedBy;
    private String uploadedByUserId;
    private Long uploadedOn;
    private Integer numOfEntries;
    private BatchJobStatus status;
    private String logFileUrl;
    private String csvFileUrl;
    private String bulkFileUrl;
    private BulkUploadType bulkUploadType;
    private List<BulkUploadResult> results;
    private String error;
    private BatchJobErrorTypes errorType;
    private Integer errorNumber;
    private String fileName;
    private String description;
    private Integer numOfObjects;
    private BulkUploadObjectType bulkUploadObjectType;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void id(String multirequestToken) {
        this.setToken("id", multirequestToken);
    }

    public String getUploadedBy() {
        return this.uploadedBy;
    }

    public void setUploadedBy(String uploadedBy) {
        this.uploadedBy = uploadedBy;
    }

    public void uploadedBy(String multirequestToken) {
        this.setToken("uploadedBy", multirequestToken);
    }

    public String getUploadedByUserId() {
        return this.uploadedByUserId;
    }

    public void setUploadedByUserId(String uploadedByUserId) {
        this.uploadedByUserId = uploadedByUserId;
    }

    public void uploadedByUserId(String multirequestToken) {
        this.setToken("uploadedByUserId", multirequestToken);
    }

    public Long getUploadedOn() {
        return this.uploadedOn;
    }

    public void setUploadedOn(Long uploadedOn) {
        this.uploadedOn = uploadedOn;
    }

    public void uploadedOn(String multirequestToken) {
        this.setToken("uploadedOn", multirequestToken);
    }

    public Integer getNumOfEntries() {
        return this.numOfEntries;
    }

    public void setNumOfEntries(Integer numOfEntries) {
        this.numOfEntries = numOfEntries;
    }

    public void numOfEntries(String multirequestToken) {
        this.setToken("numOfEntries", multirequestToken);
    }

    public BatchJobStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatchJobStatus status) {
        this.status = status;
    }

    public void status(String multirequestToken) {
        this.setToken("status", multirequestToken);
    }

    public String getLogFileUrl() {
        return this.logFileUrl;
    }

    public void setLogFileUrl(String logFileUrl) {
        this.logFileUrl = logFileUrl;
    }

    public void logFileUrl(String multirequestToken) {
        this.setToken("logFileUrl", multirequestToken);
    }

    public String getCsvFileUrl() {
        return this.csvFileUrl;
    }

    public void setCsvFileUrl(String csvFileUrl) {
        this.csvFileUrl = csvFileUrl;
    }

    public void csvFileUrl(String multirequestToken) {
        this.setToken("csvFileUrl", multirequestToken);
    }

    public String getBulkFileUrl() {
        return this.bulkFileUrl;
    }

    public void setBulkFileUrl(String bulkFileUrl) {
        this.bulkFileUrl = bulkFileUrl;
    }

    public void bulkFileUrl(String multirequestToken) {
        this.setToken("bulkFileUrl", multirequestToken);
    }

    public BulkUploadType getBulkUploadType() {
        return this.bulkUploadType;
    }

    public void setBulkUploadType(BulkUploadType bulkUploadType) {
        this.bulkUploadType = bulkUploadType;
    }

    public void bulkUploadType(String multirequestToken) {
        this.setToken("bulkUploadType", multirequestToken);
    }

    public List<BulkUploadResult> getResults() {
        return this.results;
    }

    public void setResults(List<BulkUploadResult> results) {
        this.results = results;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void error(String multirequestToken) {
        this.setToken("error", multirequestToken);
    }

    public BatchJobErrorTypes getErrorType() {
        return this.errorType;
    }

    public void setErrorType(BatchJobErrorTypes errorType) {
        this.errorType = errorType;
    }

    public void errorType(String multirequestToken) {
        this.setToken("errorType", multirequestToken);
    }

    public Integer getErrorNumber() {
        return this.errorNumber;
    }

    public void setErrorNumber(Integer errorNumber) {
        this.errorNumber = errorNumber;
    }

    public void errorNumber(String multirequestToken) {
        this.setToken("errorNumber", multirequestToken);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void fileName(String multirequestToken) {
        this.setToken("fileName", multirequestToken);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void description(String multirequestToken) {
        this.setToken("description", multirequestToken);
    }

    public Integer getNumOfObjects() {
        return this.numOfObjects;
    }

    public void setNumOfObjects(Integer numOfObjects) {
        this.numOfObjects = numOfObjects;
    }

    public void numOfObjects(String multirequestToken) {
        this.setToken("numOfObjects", multirequestToken);
    }

    public BulkUploadObjectType getBulkUploadObjectType() {
        return this.bulkUploadObjectType;
    }

    public void setBulkUploadObjectType(BulkUploadObjectType bulkUploadObjectType) {
        this.bulkUploadObjectType = bulkUploadObjectType;
    }

    public void bulkUploadObjectType(String multirequestToken) {
        this.setToken("bulkUploadObjectType", multirequestToken);
    }

    public BulkUpload() {
    }

    public BulkUpload(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseLong(jsonObject.get("id"));
        this.uploadedBy = GsonParser.parseString(jsonObject.get("uploadedBy"));
        this.uploadedByUserId = GsonParser.parseString(jsonObject.get("uploadedByUserId"));
        this.uploadedOn = GsonParser.parseLong(jsonObject.get("uploadedOn"));
        this.numOfEntries = GsonParser.parseInt(jsonObject.get("numOfEntries"));
        this.status = BatchJobStatus.get(GsonParser.parseInt(jsonObject.get("status")));
        this.logFileUrl = GsonParser.parseString(jsonObject.get("logFileUrl"));
        this.csvFileUrl = GsonParser.parseString(jsonObject.get("csvFileUrl"));
        this.bulkFileUrl = GsonParser.parseString(jsonObject.get("bulkFileUrl"));
        this.bulkUploadType = BulkUploadType.get(GsonParser.parseString(jsonObject.get("bulkUploadType")));
        this.results = GsonParser.parseArray(jsonObject.getAsJsonArray("results"), BulkUploadResult.class);
        this.error = GsonParser.parseString(jsonObject.get("error"));
        this.errorType = BatchJobErrorTypes.get(GsonParser.parseInt(jsonObject.get("errorType")));
        this.errorNumber = GsonParser.parseInt(jsonObject.get("errorNumber"));
        this.fileName = GsonParser.parseString(jsonObject.get("fileName"));
        this.description = GsonParser.parseString(jsonObject.get("description"));
        this.numOfObjects = GsonParser.parseInt(jsonObject.get("numOfObjects"));
        this.bulkUploadObjectType = BulkUploadObjectType.get(GsonParser.parseString(jsonObject.get("bulkUploadObjectType")));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaBulkUpload");
        kparams.add("id", this.id);
        kparams.add("uploadedBy", this.uploadedBy);
        kparams.add("uploadedByUserId", this.uploadedByUserId);
        kparams.add("uploadedOn", this.uploadedOn);
        kparams.add("numOfEntries", this.numOfEntries);
        kparams.add("status", this.status);
        kparams.add("logFileUrl", this.logFileUrl);
        kparams.add("csvFileUrl", this.csvFileUrl);
        kparams.add("bulkFileUrl", this.bulkFileUrl);
        kparams.add("bulkUploadType", this.bulkUploadType);
        kparams.add("results", this.results);
        kparams.add("error", this.error);
        kparams.add("errorType", this.errorType);
        kparams.add("errorNumber", this.errorNumber);
        kparams.add("fileName", this.fileName);
        kparams.add("description", this.description);
        kparams.add("numOfObjects", this.numOfObjects);
        kparams.add("bulkUploadObjectType", this.bulkUploadObjectType);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String uploadedBy();

        public String uploadedByUserId();

        public String uploadedOn();

        public String numOfEntries();

        public String status();

        public String logFileUrl();

        public String csvFileUrl();

        public String bulkFileUrl();

        public String bulkUploadType();

        public RequestBuilder.ListTokenizer<BulkUploadResult.Tokenizer> results();

        public String error();

        public String errorType();

        public String errorNumber();

        public String fileName();

        public String description();

        public String numOfObjects();

        public String bulkUploadObjectType();
    }
}

