/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.CuePoint;
import com.kaltura.client.types.StringHolder;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class AnswerCuePoint
extends CuePoint {
    private String parentId;
    private String quizUserEntryId;
    private String answerKey;
    private String openAnswer;
    private Boolean isCorrect;
    private List<StringHolder> correctAnswerKeys;
    private String explanation;
    private String feedback;

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void parentId(String multirequestToken) {
        this.setToken("parentId", multirequestToken);
    }

    public String getQuizUserEntryId() {
        return this.quizUserEntryId;
    }

    public void setQuizUserEntryId(String quizUserEntryId) {
        this.quizUserEntryId = quizUserEntryId;
    }

    public void quizUserEntryId(String multirequestToken) {
        this.setToken("quizUserEntryId", multirequestToken);
    }

    public String getAnswerKey() {
        return this.answerKey;
    }

    public void setAnswerKey(String answerKey) {
        this.answerKey = answerKey;
    }

    public void answerKey(String multirequestToken) {
        this.setToken("answerKey", multirequestToken);
    }

    public String getOpenAnswer() {
        return this.openAnswer;
    }

    public void setOpenAnswer(String openAnswer) {
        this.openAnswer = openAnswer;
    }

    public void openAnswer(String multirequestToken) {
        this.setToken("openAnswer", multirequestToken);
    }

    public Boolean getIsCorrect() {
        return this.isCorrect;
    }

    public List<StringHolder> getCorrectAnswerKeys() {
        return this.correctAnswerKeys;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getFeedback() {
        return this.feedback;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }

    public void feedback(String multirequestToken) {
        this.setToken("feedback", multirequestToken);
    }

    public AnswerCuePoint() {
    }

    public AnswerCuePoint(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.parentId = GsonParser.parseString(jsonObject.get("parentId"));
        this.quizUserEntryId = GsonParser.parseString(jsonObject.get("quizUserEntryId"));
        this.answerKey = GsonParser.parseString(jsonObject.get("answerKey"));
        this.openAnswer = GsonParser.parseString(jsonObject.get("openAnswer"));
        this.isCorrect = GsonParser.parseBoolean(jsonObject.get("isCorrect"));
        this.correctAnswerKeys = GsonParser.parseArray(jsonObject.getAsJsonArray("correctAnswerKeys"), StringHolder.class);
        this.explanation = GsonParser.parseString(jsonObject.get("explanation"));
        this.feedback = GsonParser.parseString(jsonObject.get("feedback"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaAnswerCuePoint");
        kparams.add("parentId", this.parentId);
        kparams.add("quizUserEntryId", this.quizUserEntryId);
        kparams.add("answerKey", this.answerKey);
        kparams.add("openAnswer", this.openAnswer);
        kparams.add("feedback", this.feedback);
        return kparams;
    }

    public static interface Tokenizer
    extends CuePoint.Tokenizer {
        public String parentId();

        public String quizUserEntryId();

        public String answerKey();

        public String openAnswer();

        public String isCorrect();

        public RequestBuilder.ListTokenizer<StringHolder.Tokenizer> correctAnswerKeys();

        public String explanation();

        public String feedback();
    }
}

