/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.kaltura.client.utils.response.ResponseType;

public class APIException
extends Exception
implements ResponseType {
    private static final long serialVersionUID = 6710104690443289367L;
    public static final String DefaultResponseError = "Failed getting response";
    private String code = null;
    private String message = null;
    private FailureStep failedOn;

    public APIException() {
    }

    public APIException(String message) {
        super(message);
        this.message = message;
    }

    public APIException(FailureStep step, String message) {
        super(message);
        this.code = step.code;
        this.failedOn = step;
    }

    public APIException(FailureStep step, String message, String excCode) {
        super(message);
        this.failedOn = step;
        this.code = excCode;
    }

    public APIException(Throwable exp) {
        super(exp);
    }

    public APIException(FailureStep step, Throwable exp) {
        super(exp);
        this.failedOn = step;
        this.code = step.code;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public FailureStep getFailedOn() {
        return this.failedOn;
    }

    public void setFailedOn(FailureStep failedOn) {
        this.failedOn = failedOn;
    }

    public static enum FailureStep {
        OnRequest("001"),
        OnConfigure("002"),
        OnPass("003"),
        OnResponse("004");

        public String code = "0";

        private FailureStep(String code) {
            this.code = code;
        }
    }
}

