/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.UserRole;
import com.kaltura.client.types.UserRoleFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class UserRoleService {
    public static AddUserRoleBuilder add(UserRole userRole) {
        return new AddUserRoleBuilder(userRole);
    }

    public static CloneUserRoleBuilder clone(int userRoleId) {
        return new CloneUserRoleBuilder(userRoleId);
    }

    public static DeleteUserRoleBuilder delete(int userRoleId) {
        return new DeleteUserRoleBuilder(userRoleId);
    }

    public static GetUserRoleBuilder get(int userRoleId) {
        return new GetUserRoleBuilder(userRoleId);
    }

    public static ListUserRoleBuilder list() {
        return UserRoleService.list(null);
    }

    public static ListUserRoleBuilder list(UserRoleFilter filter) {
        return UserRoleService.list(filter, null);
    }

    public static ListUserRoleBuilder list(UserRoleFilter filter, FilterPager pager) {
        return new ListUserRoleBuilder(filter, pager);
    }

    public static UpdateUserRoleBuilder update(int userRoleId, UserRole userRole) {
        return new UpdateUserRoleBuilder(userRoleId, userRole);
    }

    public static class UpdateUserRoleBuilder
    extends RequestBuilder<UserRole, UserRole.Tokenizer, UpdateUserRoleBuilder> {
        public UpdateUserRoleBuilder(int userRoleId, UserRole userRole) {
            super(UserRole.class, "userrole", "update");
            this.params.add("userRoleId", userRoleId);
            this.params.add("userRole", userRole);
        }

        public void userRoleId(String multirequestToken) {
            this.params.add("userRoleId", multirequestToken);
        }
    }

    public static class ListUserRoleBuilder
    extends ListResponseRequestBuilder<UserRole, UserRole.Tokenizer, ListUserRoleBuilder> {
        public ListUserRoleBuilder(UserRoleFilter filter, FilterPager pager) {
            super(UserRole.class, "userrole", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetUserRoleBuilder
    extends RequestBuilder<UserRole, UserRole.Tokenizer, GetUserRoleBuilder> {
        public GetUserRoleBuilder(int userRoleId) {
            super(UserRole.class, "userrole", "get");
            this.params.add("userRoleId", userRoleId);
        }

        public void userRoleId(String multirequestToken) {
            this.params.add("userRoleId", multirequestToken);
        }
    }

    public static class DeleteUserRoleBuilder
    extends RequestBuilder<UserRole, UserRole.Tokenizer, DeleteUserRoleBuilder> {
        public DeleteUserRoleBuilder(int userRoleId) {
            super(UserRole.class, "userrole", "delete");
            this.params.add("userRoleId", userRoleId);
        }

        public void userRoleId(String multirequestToken) {
            this.params.add("userRoleId", multirequestToken);
        }
    }

    public static class CloneUserRoleBuilder
    extends RequestBuilder<UserRole, UserRole.Tokenizer, CloneUserRoleBuilder> {
        public CloneUserRoleBuilder(int userRoleId) {
            super(UserRole.class, "userrole", "clone");
            this.params.add("userRoleId", userRoleId);
        }

        public void userRoleId(String multirequestToken) {
            this.params.add("userRoleId", multirequestToken);
        }
    }

    public static class AddUserRoleBuilder
    extends RequestBuilder<UserRole, UserRole.Tokenizer, AddUserRoleBuilder> {
        public AddUserRoleBuilder(UserRole userRole) {
            super(UserRole.class, "userrole", "add");
            this.params.add("userRole", userRole);
        }
    }
}

