/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.UploadToken;
import com.kaltura.client.types.UploadTokenFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class UploadTokenService {
    public static AddUploadTokenBuilder add() {
        return UploadTokenService.add(null);
    }

    public static AddUploadTokenBuilder add(UploadToken uploadToken) {
        return new AddUploadTokenBuilder(uploadToken);
    }

    public static DeleteUploadTokenBuilder delete(String uploadTokenId) {
        return new DeleteUploadTokenBuilder(uploadTokenId);
    }

    public static GetUploadTokenBuilder get(String uploadTokenId) {
        return new GetUploadTokenBuilder(uploadTokenId);
    }

    public static ListUploadTokenBuilder list() {
        return UploadTokenService.list(null);
    }

    public static ListUploadTokenBuilder list(UploadTokenFilter filter) {
        return UploadTokenService.list(filter, null);
    }

    public static ListUploadTokenBuilder list(UploadTokenFilter filter, FilterPager pager) {
        return new ListUploadTokenBuilder(filter, pager);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, FileHolder fileData) {
        return UploadTokenService.upload(uploadTokenId, fileData, false);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, File fileData) {
        return UploadTokenService.upload(uploadTokenId, new FileHolder(fileData), false);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return UploadTokenService.upload(uploadTokenId, new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), false);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return UploadTokenService.upload(uploadTokenId, new FileHolder(fileData, fileDataMimeType, fileDataName), false);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, FileHolder fileData, boolean resume) {
        return UploadTokenService.upload(uploadTokenId, fileData, resume, true);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, File fileData, boolean resume) {
        return UploadTokenService.upload(uploadTokenId, new FileHolder(fileData), resume, true);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, boolean resume) {
        return UploadTokenService.upload(uploadTokenId, new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), resume, true);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, FileInputStream fileData, String fileDataMimeType, String fileDataName, boolean resume) {
        return UploadTokenService.upload(uploadTokenId, new FileHolder(fileData, fileDataMimeType, fileDataName), resume, true);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, FileHolder fileData, boolean resume, boolean finalChunk) {
        return UploadTokenService.upload(uploadTokenId, fileData, resume, finalChunk, -1.0);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, File fileData, boolean resume, boolean finalChunk) {
        return UploadTokenService.upload(uploadTokenId, new FileHolder(fileData), resume, finalChunk, -1.0);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, boolean resume, boolean finalChunk) {
        return UploadTokenService.upload(uploadTokenId, new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), resume, finalChunk, -1.0);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, FileInputStream fileData, String fileDataMimeType, String fileDataName, boolean resume, boolean finalChunk) {
        return UploadTokenService.upload(uploadTokenId, new FileHolder(fileData, fileDataMimeType, fileDataName), resume, finalChunk, -1.0);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, File fileData, boolean resume, boolean finalChunk, double resumeAt) {
        return UploadTokenService.upload(uploadTokenId, new FileHolder(fileData), resume, finalChunk, resumeAt);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, boolean resume, boolean finalChunk, double resumeAt) {
        return UploadTokenService.upload(uploadTokenId, new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), resume, finalChunk, resumeAt);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, FileInputStream fileData, String fileDataMimeType, String fileDataName, boolean resume, boolean finalChunk, double resumeAt) {
        return UploadTokenService.upload(uploadTokenId, new FileHolder(fileData, fileDataMimeType, fileDataName), resume, finalChunk, resumeAt);
    }

    public static UploadUploadTokenBuilder upload(String uploadTokenId, FileHolder fileData, boolean resume, boolean finalChunk, double resumeAt) {
        return new UploadUploadTokenBuilder(uploadTokenId, fileData, resume, finalChunk, resumeAt);
    }

    public static class UploadUploadTokenBuilder
    extends RequestBuilder<UploadToken, UploadToken.Tokenizer, UploadUploadTokenBuilder> {
        public UploadUploadTokenBuilder(String uploadTokenId, FileHolder fileData, boolean resume, boolean finalChunk, double resumeAt) {
            super(UploadToken.class, "uploadtoken", "upload");
            this.params.add("uploadTokenId", uploadTokenId);
            this.files = new Files();
            this.files.add("fileData", fileData);
            this.params.add("resume", resume);
            this.params.add("finalChunk", finalChunk);
            this.params.add("resumeAt", resumeAt);
        }

        public void uploadTokenId(String multirequestToken) {
            this.params.add("uploadTokenId", multirequestToken);
        }

        public void resume(String multirequestToken) {
            this.params.add("resume", multirequestToken);
        }

        public void finalChunk(String multirequestToken) {
            this.params.add("finalChunk", multirequestToken);
        }

        public void resumeAt(String multirequestToken) {
            this.params.add("resumeAt", multirequestToken);
        }
    }

    public static class ListUploadTokenBuilder
    extends ListResponseRequestBuilder<UploadToken, UploadToken.Tokenizer, ListUploadTokenBuilder> {
        public ListUploadTokenBuilder(UploadTokenFilter filter, FilterPager pager) {
            super(UploadToken.class, "uploadtoken", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetUploadTokenBuilder
    extends RequestBuilder<UploadToken, UploadToken.Tokenizer, GetUploadTokenBuilder> {
        public GetUploadTokenBuilder(String uploadTokenId) {
            super(UploadToken.class, "uploadtoken", "get");
            this.params.add("uploadTokenId", uploadTokenId);
        }

        public void uploadTokenId(String multirequestToken) {
            this.params.add("uploadTokenId", multirequestToken);
        }
    }

    public static class DeleteUploadTokenBuilder
    extends NullRequestBuilder {
        public DeleteUploadTokenBuilder(String uploadTokenId) {
            super("uploadtoken", "delete");
            this.params.add("uploadTokenId", uploadTokenId);
        }

        public void uploadTokenId(String multirequestToken) {
            this.params.add("uploadTokenId", multirequestToken);
        }
    }

    public static class AddUploadTokenBuilder
    extends RequestBuilder<UploadToken, UploadToken.Tokenizer, AddUploadTokenBuilder> {
        public AddUploadTokenBuilder(UploadToken uploadToken) {
            super(UploadToken.class, "uploadtoken", "add");
            this.params.add("uploadToken", uploadToken);
        }
    }
}

