/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.enums.SessionType;
import com.kaltura.client.types.SessionInfo;
import com.kaltura.client.types.StartWidgetSessionResponse;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class SessionService {
    public static EndSessionBuilder end() {
        return new EndSessionBuilder();
    }

    public static GetSessionBuilder get() {
        return SessionService.get(null);
    }

    public static GetSessionBuilder get(String session) {
        return new GetSessionBuilder(session);
    }

    public static ImpersonateSessionBuilder impersonate(String secret, int impersonatedPartnerId) {
        return SessionService.impersonate(secret, impersonatedPartnerId, "");
    }

    public static ImpersonateSessionBuilder impersonate(String secret, int impersonatedPartnerId, String userId) {
        return SessionService.impersonate(secret, impersonatedPartnerId, userId, SessionType.get(0));
    }

    public static ImpersonateSessionBuilder impersonate(String secret, int impersonatedPartnerId, String userId, SessionType type) {
        return SessionService.impersonate(secret, impersonatedPartnerId, userId, type, Integer.MIN_VALUE);
    }

    public static ImpersonateSessionBuilder impersonate(String secret, int impersonatedPartnerId, String userId, SessionType type, int partnerId) {
        return SessionService.impersonate(secret, impersonatedPartnerId, userId, type, partnerId, 86400);
    }

    public static ImpersonateSessionBuilder impersonate(String secret, int impersonatedPartnerId, String userId, SessionType type, int partnerId, int expiry) {
        return SessionService.impersonate(secret, impersonatedPartnerId, userId, type, partnerId, expiry, null);
    }

    public static ImpersonateSessionBuilder impersonate(String secret, int impersonatedPartnerId, String userId, SessionType type, int partnerId, int expiry, String privileges) {
        return new ImpersonateSessionBuilder(secret, impersonatedPartnerId, userId, type, partnerId, expiry, privileges);
    }

    public static ImpersonateByKsSessionBuilder impersonateByKs(String session) {
        return SessionService.impersonateByKs(session, SessionType.get(Integer.MIN_VALUE));
    }

    public static ImpersonateByKsSessionBuilder impersonateByKs(String session, SessionType type) {
        return SessionService.impersonateByKs(session, type, Integer.MIN_VALUE);
    }

    public static ImpersonateByKsSessionBuilder impersonateByKs(String session, SessionType type, int expiry) {
        return SessionService.impersonateByKs(session, type, expiry, null);
    }

    public static ImpersonateByKsSessionBuilder impersonateByKs(String session, SessionType type, int expiry, String privileges) {
        return new ImpersonateByKsSessionBuilder(session, type, expiry, privileges);
    }

    public static StartSessionBuilder start(String secret) {
        return SessionService.start(secret, "");
    }

    public static StartSessionBuilder start(String secret, String userId) {
        return SessionService.start(secret, userId, SessionType.get(0));
    }

    public static StartSessionBuilder start(String secret, String userId, SessionType type) {
        return SessionService.start(secret, userId, type, Integer.MIN_VALUE);
    }

    public static StartSessionBuilder start(String secret, String userId, SessionType type, int partnerId) {
        return SessionService.start(secret, userId, type, partnerId, 86400);
    }

    public static StartSessionBuilder start(String secret, String userId, SessionType type, int partnerId, int expiry) {
        return SessionService.start(secret, userId, type, partnerId, expiry, null);
    }

    public static StartSessionBuilder start(String secret, String userId, SessionType type, int partnerId, int expiry, String privileges) {
        return new StartSessionBuilder(secret, userId, type, partnerId, expiry, privileges);
    }

    public static StartWidgetSessionSessionBuilder startWidgetSession(String widgetId) {
        return SessionService.startWidgetSession(widgetId, 86400);
    }

    public static StartWidgetSessionSessionBuilder startWidgetSession(String widgetId, int expiry) {
        return new StartWidgetSessionSessionBuilder(widgetId, expiry);
    }

    public static class StartWidgetSessionSessionBuilder
    extends RequestBuilder<StartWidgetSessionResponse, StartWidgetSessionResponse.Tokenizer, StartWidgetSessionSessionBuilder> {
        public StartWidgetSessionSessionBuilder(String widgetId, int expiry) {
            super(StartWidgetSessionResponse.class, "session", "startWidgetSession");
            this.params.add("widgetId", widgetId);
            this.params.add("expiry", expiry);
        }

        public void widgetId(String multirequestToken) {
            this.params.add("widgetId", multirequestToken);
        }

        public void expiry(String multirequestToken) {
            this.params.add("expiry", multirequestToken);
        }
    }

    public static class StartSessionBuilder
    extends RequestBuilder<String, String, StartSessionBuilder> {
        public StartSessionBuilder(String secret, String userId, SessionType type, int partnerId, int expiry, String privileges) {
            super(String.class, "session", "start");
            this.params.add("secret", secret);
            this.params.add("userId", userId);
            this.params.add("type", type);
            this.params.add("partnerId", partnerId);
            this.params.add("expiry", expiry);
            this.params.add("privileges", privileges);
        }

        public void secret(String multirequestToken) {
            this.params.add("secret", multirequestToken);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }

        public void type(String multirequestToken) {
            this.params.add("type", multirequestToken);
        }

        public void partnerId(String multirequestToken) {
            this.params.add("partnerId", multirequestToken);
        }

        public void expiry(String multirequestToken) {
            this.params.add("expiry", multirequestToken);
        }

        public void privileges(String multirequestToken) {
            this.params.add("privileges", multirequestToken);
        }
    }

    public static class ImpersonateByKsSessionBuilder
    extends RequestBuilder<SessionInfo, SessionInfo.Tokenizer, ImpersonateByKsSessionBuilder> {
        public ImpersonateByKsSessionBuilder(String session, SessionType type, int expiry, String privileges) {
            super(SessionInfo.class, "session", "impersonateByKs");
            this.params.add("session", session);
            this.params.add("type", type);
            this.params.add("expiry", expiry);
            this.params.add("privileges", privileges);
        }

        public void session(String multirequestToken) {
            this.params.add("session", multirequestToken);
        }

        public void type(String multirequestToken) {
            this.params.add("type", multirequestToken);
        }

        public void expiry(String multirequestToken) {
            this.params.add("expiry", multirequestToken);
        }

        public void privileges(String multirequestToken) {
            this.params.add("privileges", multirequestToken);
        }
    }

    public static class ImpersonateSessionBuilder
    extends RequestBuilder<String, String, ImpersonateSessionBuilder> {
        public ImpersonateSessionBuilder(String secret, int impersonatedPartnerId, String userId, SessionType type, int partnerId, int expiry, String privileges) {
            super(String.class, "session", "impersonate");
            this.params.add("secret", secret);
            this.params.add("impersonatedPartnerId", impersonatedPartnerId);
            this.params.add("userId", userId);
            this.params.add("type", type);
            this.params.add("partnerId", partnerId);
            this.params.add("expiry", expiry);
            this.params.add("privileges", privileges);
        }

        public void secret(String multirequestToken) {
            this.params.add("secret", multirequestToken);
        }

        public void impersonatedPartnerId(String multirequestToken) {
            this.params.add("impersonatedPartnerId", multirequestToken);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }

        public void type(String multirequestToken) {
            this.params.add("type", multirequestToken);
        }

        public void partnerId(String multirequestToken) {
            this.params.add("partnerId", multirequestToken);
        }

        public void expiry(String multirequestToken) {
            this.params.add("expiry", multirequestToken);
        }

        public void privileges(String multirequestToken) {
            this.params.add("privileges", multirequestToken);
        }
    }

    public static class GetSessionBuilder
    extends RequestBuilder<SessionInfo, SessionInfo.Tokenizer, GetSessionBuilder> {
        public GetSessionBuilder(String session) {
            super(SessionInfo.class, "session", "get");
            this.params.add("session", session);
        }

        public void session(String multirequestToken) {
            this.params.add("session", multirequestToken);
        }
    }

    public static class EndSessionBuilder
    extends NullRequestBuilder {
        public EndSessionBuilder() {
            super("session", "end");
        }
    }
}

