/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.PermissionItem;
import com.kaltura.client.types.PermissionItemFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class PermissionItemService {
    public static AddPermissionItemBuilder add(PermissionItem permissionItem) {
        return new AddPermissionItemBuilder(permissionItem);
    }

    public static DeletePermissionItemBuilder delete(int permissionItemId) {
        return new DeletePermissionItemBuilder(permissionItemId);
    }

    public static GetPermissionItemBuilder get(int permissionItemId) {
        return new GetPermissionItemBuilder(permissionItemId);
    }

    public static ListPermissionItemBuilder list() {
        return PermissionItemService.list(null);
    }

    public static ListPermissionItemBuilder list(PermissionItemFilter filter) {
        return PermissionItemService.list(filter, null);
    }

    public static ListPermissionItemBuilder list(PermissionItemFilter filter, FilterPager pager) {
        return new ListPermissionItemBuilder(filter, pager);
    }

    public static UpdatePermissionItemBuilder update(int permissionItemId, PermissionItem permissionItem) {
        return new UpdatePermissionItemBuilder(permissionItemId, permissionItem);
    }

    public static class UpdatePermissionItemBuilder
    extends RequestBuilder<PermissionItem, PermissionItem.Tokenizer, UpdatePermissionItemBuilder> {
        public UpdatePermissionItemBuilder(int permissionItemId, PermissionItem permissionItem) {
            super(PermissionItem.class, "permissionitem", "update");
            this.params.add("permissionItemId", permissionItemId);
            this.params.add("permissionItem", permissionItem);
        }

        public void permissionItemId(String multirequestToken) {
            this.params.add("permissionItemId", multirequestToken);
        }
    }

    public static class ListPermissionItemBuilder
    extends ListResponseRequestBuilder<PermissionItem, PermissionItem.Tokenizer, ListPermissionItemBuilder> {
        public ListPermissionItemBuilder(PermissionItemFilter filter, FilterPager pager) {
            super(PermissionItem.class, "permissionitem", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetPermissionItemBuilder
    extends RequestBuilder<PermissionItem, PermissionItem.Tokenizer, GetPermissionItemBuilder> {
        public GetPermissionItemBuilder(int permissionItemId) {
            super(PermissionItem.class, "permissionitem", "get");
            this.params.add("permissionItemId", permissionItemId);
        }

        public void permissionItemId(String multirequestToken) {
            this.params.add("permissionItemId", multirequestToken);
        }
    }

    public static class DeletePermissionItemBuilder
    extends RequestBuilder<PermissionItem, PermissionItem.Tokenizer, DeletePermissionItemBuilder> {
        public DeletePermissionItemBuilder(int permissionItemId) {
            super(PermissionItem.class, "permissionitem", "delete");
            this.params.add("permissionItemId", permissionItemId);
        }

        public void permissionItemId(String multirequestToken) {
            this.params.add("permissionItemId", multirequestToken);
        }
    }

    public static class AddPermissionItemBuilder
    extends RequestBuilder<PermissionItem, PermissionItem.Tokenizer, AddPermissionItemBuilder> {
        public AddPermissionItemBuilder(PermissionItem permissionItem) {
            super(PermissionItem.class, "permissionitem", "add");
            this.params.add("permissionItem", permissionItem);
        }
    }
}

