/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.enums.ReportInterval;
import com.kaltura.client.types.FeatureStatus;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.Partner;
import com.kaltura.client.types.PartnerFilter;
import com.kaltura.client.types.PartnerPublicInfo;
import com.kaltura.client.types.PartnerStatistics;
import com.kaltura.client.types.PartnerUsage;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class PartnerService {
    public static CountPartnerBuilder count() {
        return PartnerService.count(null);
    }

    public static CountPartnerBuilder count(PartnerFilter filter) {
        return new CountPartnerBuilder(filter);
    }

    public static GetPartnerBuilder get() {
        return PartnerService.get(Long.MIN_VALUE);
    }

    public static GetPartnerBuilder get(long id) {
        return new GetPartnerBuilder(id);
    }

    public static GetInfoPartnerBuilder getInfo() {
        return new GetInfoPartnerBuilder();
    }

    public static GetPublicInfoPartnerBuilder getPublicInfo() {
        return PartnerService.getPublicInfo(Long.MIN_VALUE);
    }

    public static GetPublicInfoPartnerBuilder getPublicInfo(long id) {
        return new GetPublicInfoPartnerBuilder(id);
    }

    public static GetSecretsPartnerBuilder getSecrets(int partnerId, String adminEmail, String cmsPassword) {
        return PartnerService.getSecrets(partnerId, adminEmail, cmsPassword, null);
    }

    public static GetSecretsPartnerBuilder getSecrets(int partnerId, String adminEmail, String cmsPassword, String otp) {
        return new GetSecretsPartnerBuilder(partnerId, adminEmail, cmsPassword, otp);
    }

    public static GetStatisticsPartnerBuilder getStatistics() {
        return new GetStatisticsPartnerBuilder();
    }

    public static GetUsagePartnerBuilder getUsage() {
        return PartnerService.getUsage();
    }

    public static GetUsagePartnerBuilder getUsage(int year) {
        return PartnerService.getUsage(year, 1);
    }

    public static GetUsagePartnerBuilder getUsage(int year, int month) {
        return PartnerService.getUsage(year, month, null);
    }

    public static GetUsagePartnerBuilder getUsage(int year, int month, ReportInterval resolution) {
        return new GetUsagePartnerBuilder(year, month, resolution);
    }

    public static ListPartnerBuilder list() {
        return PartnerService.list(null);
    }

    public static ListPartnerBuilder list(PartnerFilter filter) {
        return PartnerService.list(filter, null);
    }

    public static ListPartnerBuilder list(PartnerFilter filter, FilterPager pager) {
        return new ListPartnerBuilder(filter, pager);
    }

    public static ListFeatureStatusPartnerBuilder listFeatureStatus() {
        return new ListFeatureStatusPartnerBuilder();
    }

    public static ListPartnersForUserPartnerBuilder listPartnersForUser() {
        return PartnerService.listPartnersForUser(null);
    }

    public static ListPartnersForUserPartnerBuilder listPartnersForUser(PartnerFilter partnerFilter) {
        return PartnerService.listPartnersForUser(partnerFilter, null);
    }

    public static ListPartnersForUserPartnerBuilder listPartnersForUser(PartnerFilter partnerFilter, FilterPager pager) {
        return new ListPartnersForUserPartnerBuilder(partnerFilter, pager);
    }

    public static RegisterPartnerBuilder register(Partner partner) {
        return PartnerService.register(partner, "");
    }

    public static RegisterPartnerBuilder register(Partner partner, String cmsPassword) {
        return PartnerService.register(partner, cmsPassword, Integer.MIN_VALUE);
    }

    public static RegisterPartnerBuilder register(Partner partner, String cmsPassword, int templatePartnerId) {
        return PartnerService.register(partner, cmsPassword, templatePartnerId, false);
    }

    public static RegisterPartnerBuilder register(Partner partner, String cmsPassword, int templatePartnerId, boolean silent) {
        return new RegisterPartnerBuilder(partner, cmsPassword, templatePartnerId, silent);
    }

    public static RegistrationValidationPartnerBuilder registrationValidation(Partner partner) {
        return PartnerService.registrationValidation(partner, "");
    }

    public static RegistrationValidationPartnerBuilder registrationValidation(Partner partner, String cmsPassword) {
        return PartnerService.registrationValidation(partner, cmsPassword, Integer.MIN_VALUE);
    }

    public static RegistrationValidationPartnerBuilder registrationValidation(Partner partner, String cmsPassword, int templatePartnerId) {
        return PartnerService.registrationValidation(partner, cmsPassword, templatePartnerId, false);
    }

    public static RegistrationValidationPartnerBuilder registrationValidation(Partner partner, String cmsPassword, int templatePartnerId, boolean silent) {
        return new RegistrationValidationPartnerBuilder(partner, cmsPassword, templatePartnerId, silent);
    }

    public static UpdatePartnerBuilder update(Partner partner) {
        return PartnerService.update(partner, false);
    }

    public static UpdatePartnerBuilder update(Partner partner, boolean allowEmpty) {
        return new UpdatePartnerBuilder(partner, allowEmpty);
    }

    public static class UpdatePartnerBuilder
    extends RequestBuilder<Partner, Partner.Tokenizer, UpdatePartnerBuilder> {
        public UpdatePartnerBuilder(Partner partner, boolean allowEmpty) {
            super(Partner.class, "partner", "update");
            this.params.add("partner", partner);
            this.params.add("allowEmpty", allowEmpty);
        }

        public void allowEmpty(String multirequestToken) {
            this.params.add("allowEmpty", multirequestToken);
        }
    }

    public static class RegistrationValidationPartnerBuilder
    extends RequestBuilder<Boolean, String, RegistrationValidationPartnerBuilder> {
        public RegistrationValidationPartnerBuilder(Partner partner, String cmsPassword, int templatePartnerId, boolean silent) {
            super(Boolean.class, "partner", "registrationValidation");
            this.params.add("partner", partner);
            this.params.add("cmsPassword", cmsPassword);
            this.params.add("templatePartnerId", templatePartnerId);
            this.params.add("silent", silent);
        }

        public void cmsPassword(String multirequestToken) {
            this.params.add("cmsPassword", multirequestToken);
        }

        public void templatePartnerId(String multirequestToken) {
            this.params.add("templatePartnerId", multirequestToken);
        }

        public void silent(String multirequestToken) {
            this.params.add("silent", multirequestToken);
        }
    }

    public static class RegisterPartnerBuilder
    extends RequestBuilder<Partner, Partner.Tokenizer, RegisterPartnerBuilder> {
        public RegisterPartnerBuilder(Partner partner, String cmsPassword, int templatePartnerId, boolean silent) {
            super(Partner.class, "partner", "register");
            this.params.add("partner", partner);
            this.params.add("cmsPassword", cmsPassword);
            this.params.add("templatePartnerId", templatePartnerId);
            this.params.add("silent", silent);
        }

        public void cmsPassword(String multirequestToken) {
            this.params.add("cmsPassword", multirequestToken);
        }

        public void templatePartnerId(String multirequestToken) {
            this.params.add("templatePartnerId", multirequestToken);
        }

        public void silent(String multirequestToken) {
            this.params.add("silent", multirequestToken);
        }
    }

    public static class ListPartnersForUserPartnerBuilder
    extends ListResponseRequestBuilder<Partner, Partner.Tokenizer, ListPartnersForUserPartnerBuilder> {
        public ListPartnersForUserPartnerBuilder(PartnerFilter partnerFilter, FilterPager pager) {
            super(Partner.class, "partner", "listPartnersForUser");
            this.params.add("partnerFilter", partnerFilter);
            this.params.add("pager", pager);
        }
    }

    public static class ListFeatureStatusPartnerBuilder
    extends ListResponseRequestBuilder<FeatureStatus, FeatureStatus.Tokenizer, ListFeatureStatusPartnerBuilder> {
        public ListFeatureStatusPartnerBuilder() {
            super(FeatureStatus.class, "partner", "listFeatureStatus");
        }
    }

    public static class ListPartnerBuilder
    extends ListResponseRequestBuilder<Partner, Partner.Tokenizer, ListPartnerBuilder> {
        public ListPartnerBuilder(PartnerFilter filter, FilterPager pager) {
            super(Partner.class, "partner", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetUsagePartnerBuilder
    extends RequestBuilder<PartnerUsage, PartnerUsage.Tokenizer, GetUsagePartnerBuilder> {
        public GetUsagePartnerBuilder(int year, int month, ReportInterval resolution) {
            super(PartnerUsage.class, "partner", "getUsage");
            this.params.add("year", year);
            this.params.add("month", month);
            this.params.add("resolution", resolution);
        }

        public void year(String multirequestToken) {
            this.params.add("year", multirequestToken);
        }

        public void month(String multirequestToken) {
            this.params.add("month", multirequestToken);
        }

        public void resolution(String multirequestToken) {
            this.params.add("resolution", multirequestToken);
        }
    }

    public static class GetStatisticsPartnerBuilder
    extends RequestBuilder<PartnerStatistics, PartnerStatistics.Tokenizer, GetStatisticsPartnerBuilder> {
        public GetStatisticsPartnerBuilder() {
            super(PartnerStatistics.class, "partner", "getStatistics");
        }
    }

    public static class GetSecretsPartnerBuilder
    extends RequestBuilder<Partner, Partner.Tokenizer, GetSecretsPartnerBuilder> {
        public GetSecretsPartnerBuilder(int partnerId, String adminEmail, String cmsPassword, String otp) {
            super(Partner.class, "partner", "getSecrets");
            this.params.add("partnerId", partnerId);
            this.params.add("adminEmail", adminEmail);
            this.params.add("cmsPassword", cmsPassword);
            this.params.add("otp", otp);
        }

        public void partnerId(String multirequestToken) {
            this.params.add("partnerId", multirequestToken);
        }

        public void adminEmail(String multirequestToken) {
            this.params.add("adminEmail", multirequestToken);
        }

        public void cmsPassword(String multirequestToken) {
            this.params.add("cmsPassword", multirequestToken);
        }

        public void otp(String multirequestToken) {
            this.params.add("otp", multirequestToken);
        }
    }

    public static class GetPublicInfoPartnerBuilder
    extends RequestBuilder<PartnerPublicInfo, PartnerPublicInfo.Tokenizer, GetPublicInfoPartnerBuilder> {
        public GetPublicInfoPartnerBuilder(long id) {
            super(PartnerPublicInfo.class, "partner", "getPublicInfo");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class GetInfoPartnerBuilder
    extends RequestBuilder<Partner, Partner.Tokenizer, GetInfoPartnerBuilder> {
        public GetInfoPartnerBuilder() {
            super(Partner.class, "partner", "getInfo");
        }
    }

    public static class GetPartnerBuilder
    extends RequestBuilder<Partner, Partner.Tokenizer, GetPartnerBuilder> {
        public GetPartnerBuilder(long id) {
            super(Partner.class, "partner", "get");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class CountPartnerBuilder
    extends RequestBuilder<Integer, String, CountPartnerBuilder> {
        public CountPartnerBuilder(PartnerFilter filter) {
            super(Integer.class, "partner", "count");
            this.params.add("filter", filter);
        }
    }
}

