/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.MediaEntry;
import com.kaltura.client.types.MediaEntryFilter;
import com.kaltura.client.types.MixEntry;
import com.kaltura.client.types.MixEntryFilter;
import com.kaltura.client.utils.request.ArrayRequestBuilder;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class MixingService {
    public static AddMixingBuilder add(MixEntry mixEntry) {
        return new AddMixingBuilder(mixEntry);
    }

    public static AnonymousRankMixingBuilder anonymousRank(String entryId, int rank) {
        return new AnonymousRankMixingBuilder(entryId, rank);
    }

    public static AppendMediaEntryMixingBuilder appendMediaEntry(String mixEntryId, String mediaEntryId) {
        return new AppendMediaEntryMixingBuilder(mixEntryId, mediaEntryId);
    }

    public static CloneMixingBuilder clone(String entryId) {
        return new CloneMixingBuilder(entryId);
    }

    public static CountMixingBuilder count() {
        return MixingService.count(null);
    }

    public static CountMixingBuilder count(MediaEntryFilter filter) {
        return new CountMixingBuilder(filter);
    }

    public static DeleteMixingBuilder delete(String entryId) {
        return new DeleteMixingBuilder(entryId);
    }

    public static GetMixingBuilder get(String entryId) {
        return MixingService.get(entryId, -1);
    }

    public static GetMixingBuilder get(String entryId, int version) {
        return new GetMixingBuilder(entryId, version);
    }

    public static GetMixesByMediaIdMixingBuilder getMixesByMediaId(String mediaEntryId) {
        return new GetMixesByMediaIdMixingBuilder(mediaEntryId);
    }

    public static GetReadyMediaEntriesMixingBuilder getReadyMediaEntries(String mixId) {
        return MixingService.getReadyMediaEntries(mixId, -1);
    }

    public static GetReadyMediaEntriesMixingBuilder getReadyMediaEntries(String mixId, int version) {
        return new GetReadyMediaEntriesMixingBuilder(mixId, version);
    }

    public static ListMixingBuilder list() {
        return MixingService.list(null);
    }

    public static ListMixingBuilder list(MixEntryFilter filter) {
        return MixingService.list(filter, null);
    }

    public static ListMixingBuilder list(MixEntryFilter filter, FilterPager pager) {
        return new ListMixingBuilder(filter, pager);
    }

    public static UpdateMixingBuilder update(String entryId, MixEntry mixEntry) {
        return new UpdateMixingBuilder(entryId, mixEntry);
    }

    public static class UpdateMixingBuilder
    extends RequestBuilder<MixEntry, MixEntry.Tokenizer, UpdateMixingBuilder> {
        public UpdateMixingBuilder(String entryId, MixEntry mixEntry) {
            super(MixEntry.class, "mixing", "update");
            this.params.add("entryId", entryId);
            this.params.add("mixEntry", mixEntry);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ListMixingBuilder
    extends ListResponseRequestBuilder<MixEntry, MixEntry.Tokenizer, ListMixingBuilder> {
        public ListMixingBuilder(MixEntryFilter filter, FilterPager pager) {
            super(MixEntry.class, "mixing", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetReadyMediaEntriesMixingBuilder
    extends ArrayRequestBuilder<MediaEntry, MediaEntry.Tokenizer, GetReadyMediaEntriesMixingBuilder> {
        public GetReadyMediaEntriesMixingBuilder(String mixId, int version) {
            super(MediaEntry.class, "mixing", "getReadyMediaEntries");
            this.params.add("mixId", mixId);
            this.params.add("version", version);
        }

        public void mixId(String multirequestToken) {
            this.params.add("mixId", multirequestToken);
        }

        public void version(String multirequestToken) {
            this.params.add("version", multirequestToken);
        }
    }

    public static class GetMixesByMediaIdMixingBuilder
    extends ArrayRequestBuilder<MixEntry, MixEntry.Tokenizer, GetMixesByMediaIdMixingBuilder> {
        public GetMixesByMediaIdMixingBuilder(String mediaEntryId) {
            super(MixEntry.class, "mixing", "getMixesByMediaId");
            this.params.add("mediaEntryId", mediaEntryId);
        }

        public void mediaEntryId(String multirequestToken) {
            this.params.add("mediaEntryId", multirequestToken);
        }
    }

    public static class GetMixingBuilder
    extends RequestBuilder<MixEntry, MixEntry.Tokenizer, GetMixingBuilder> {
        public GetMixingBuilder(String entryId, int version) {
            super(MixEntry.class, "mixing", "get");
            this.params.add("entryId", entryId);
            this.params.add("version", version);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void version(String multirequestToken) {
            this.params.add("version", multirequestToken);
        }
    }

    public static class DeleteMixingBuilder
    extends NullRequestBuilder {
        public DeleteMixingBuilder(String entryId) {
            super("mixing", "delete");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class CountMixingBuilder
    extends RequestBuilder<Integer, String, CountMixingBuilder> {
        public CountMixingBuilder(MediaEntryFilter filter) {
            super(Integer.class, "mixing", "count");
            this.params.add("filter", filter);
        }
    }

    public static class CloneMixingBuilder
    extends RequestBuilder<MixEntry, MixEntry.Tokenizer, CloneMixingBuilder> {
        public CloneMixingBuilder(String entryId) {
            super(MixEntry.class, "mixing", "clone");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class AppendMediaEntryMixingBuilder
    extends RequestBuilder<MixEntry, MixEntry.Tokenizer, AppendMediaEntryMixingBuilder> {
        public AppendMediaEntryMixingBuilder(String mixEntryId, String mediaEntryId) {
            super(MixEntry.class, "mixing", "appendMediaEntry");
            this.params.add("mixEntryId", mixEntryId);
            this.params.add("mediaEntryId", mediaEntryId);
        }

        public void mixEntryId(String multirequestToken) {
            this.params.add("mixEntryId", multirequestToken);
        }

        public void mediaEntryId(String multirequestToken) {
            this.params.add("mediaEntryId", multirequestToken);
        }
    }

    public static class AnonymousRankMixingBuilder
    extends NullRequestBuilder {
        public AnonymousRankMixingBuilder(String entryId, int rank) {
            super("mixing", "anonymousRank");
            this.params.add("entryId", entryId);
            this.params.add("rank", rank);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void rank(String multirequestToken) {
            this.params.add("rank", multirequestToken);
        }
    }

    public static class AddMixingBuilder
    extends RequestBuilder<MixEntry, MixEntry.Tokenizer, AddMixingBuilder> {
        public AddMixingBuilder(MixEntry mixEntry) {
            super(MixEntry.class, "mixing", "add");
            this.params.add("mixEntry", mixEntry);
        }
    }
}

