/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.enums.MetadataObjectType;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.Metadata;
import com.kaltura.client.types.MetadataFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.request.ServeRequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class MetadataService {
    public static AddMetadataBuilder add(int metadataProfileId, MetadataObjectType objectType, String objectId, String xmlData) {
        return new AddMetadataBuilder(metadataProfileId, objectType, objectId, xmlData);
    }

    public static AddFromBulkMetadataBuilder addFromBulk(int metadataProfileId, MetadataObjectType objectType, String objectId, String url) {
        return new AddFromBulkMetadataBuilder(metadataProfileId, objectType, objectId, url);
    }

    public static AddFromFileMetadataBuilder addFromFile(int metadataProfileId, MetadataObjectType objectType, String objectId, File xmlFile) {
        return MetadataService.addFromFile(metadataProfileId, objectType, objectId, new FileHolder(xmlFile));
    }

    public static AddFromFileMetadataBuilder addFromFile(int metadataProfileId, MetadataObjectType objectType, String objectId, InputStream xmlFile, String xmlFileMimeType, String xmlFileName, long xmlFileSize) {
        return MetadataService.addFromFile(metadataProfileId, objectType, objectId, new FileHolder(xmlFile, xmlFileMimeType, xmlFileName, xmlFileSize));
    }

    public static AddFromFileMetadataBuilder addFromFile(int metadataProfileId, MetadataObjectType objectType, String objectId, FileInputStream xmlFile, String xmlFileMimeType, String xmlFileName) {
        return MetadataService.addFromFile(metadataProfileId, objectType, objectId, new FileHolder(xmlFile, xmlFileMimeType, xmlFileName));
    }

    public static AddFromFileMetadataBuilder addFromFile(int metadataProfileId, MetadataObjectType objectType, String objectId, FileHolder xmlFile) {
        return new AddFromFileMetadataBuilder(metadataProfileId, objectType, objectId, xmlFile);
    }

    public static AddFromUrlMetadataBuilder addFromUrl(int metadataProfileId, MetadataObjectType objectType, String objectId, String url) {
        return new AddFromUrlMetadataBuilder(metadataProfileId, objectType, objectId, url);
    }

    public static DeleteMetadataBuilder delete(int id) {
        return new DeleteMetadataBuilder(id);
    }

    public static GetMetadataBuilder get(int id) {
        return new GetMetadataBuilder(id);
    }

    public static IndexMetadataBuilder index(String id, boolean shouldUpdate) {
        return new IndexMetadataBuilder(id, shouldUpdate);
    }

    public static InvalidateMetadataBuilder invalidate(int id) {
        return MetadataService.invalidate(id, Integer.MIN_VALUE);
    }

    public static InvalidateMetadataBuilder invalidate(int id, int version) {
        return new InvalidateMetadataBuilder(id, version);
    }

    public static ListMetadataBuilder list() {
        return MetadataService.list(null);
    }

    public static ListMetadataBuilder list(MetadataFilter filter) {
        return MetadataService.list(filter, null);
    }

    public static ListMetadataBuilder list(MetadataFilter filter, FilterPager pager) {
        return new ListMetadataBuilder(filter, pager);
    }

    public static ServeMetadataBuilder serve(int id) {
        return new ServeMetadataBuilder(id);
    }

    public static UpdateMetadataBuilder update(int id) {
        return MetadataService.update(id, null);
    }

    public static UpdateMetadataBuilder update(int id, String xmlData) {
        return MetadataService.update(id, xmlData, Integer.MIN_VALUE);
    }

    public static UpdateMetadataBuilder update(int id, String xmlData, int version) {
        return new UpdateMetadataBuilder(id, xmlData, version);
    }

    public static UpdateFromFileMetadataBuilder updateFromFile(int id) {
        return MetadataService.updateFromFile(id, (FileHolder)null);
    }

    public static UpdateFromFileMetadataBuilder updateFromFile(int id, File xmlFile) {
        return MetadataService.updateFromFile(id, new FileHolder(xmlFile));
    }

    public static UpdateFromFileMetadataBuilder updateFromFile(int id, InputStream xmlFile, String xmlFileMimeType, String xmlFileName, long xmlFileSize) {
        return MetadataService.updateFromFile(id, new FileHolder(xmlFile, xmlFileMimeType, xmlFileName, xmlFileSize));
    }

    public static UpdateFromFileMetadataBuilder updateFromFile(int id, FileInputStream xmlFile, String xmlFileMimeType, String xmlFileName) {
        return MetadataService.updateFromFile(id, new FileHolder(xmlFile, xmlFileMimeType, xmlFileName));
    }

    public static UpdateFromFileMetadataBuilder updateFromFile(int id, FileHolder xmlFile) {
        return new UpdateFromFileMetadataBuilder(id, xmlFile);
    }

    public static UpdateFromXSLMetadataBuilder updateFromXSL(int id, File xslFile) {
        return MetadataService.updateFromXSL(id, new FileHolder(xslFile));
    }

    public static UpdateFromXSLMetadataBuilder updateFromXSL(int id, InputStream xslFile, String xslFileMimeType, String xslFileName, long xslFileSize) {
        return MetadataService.updateFromXSL(id, new FileHolder(xslFile, xslFileMimeType, xslFileName, xslFileSize));
    }

    public static UpdateFromXSLMetadataBuilder updateFromXSL(int id, FileInputStream xslFile, String xslFileMimeType, String xslFileName) {
        return MetadataService.updateFromXSL(id, new FileHolder(xslFile, xslFileMimeType, xslFileName));
    }

    public static UpdateFromXSLMetadataBuilder updateFromXSL(int id, FileHolder xslFile) {
        return new UpdateFromXSLMetadataBuilder(id, xslFile);
    }

    public static class UpdateFromXSLMetadataBuilder
    extends RequestBuilder<Metadata, Metadata.Tokenizer, UpdateFromXSLMetadataBuilder> {
        public UpdateFromXSLMetadataBuilder(int id, FileHolder xslFile) {
            super(Metadata.class, "metadata_metadata", "updateFromXSL");
            this.params.add("id", id);
            this.files = new Files();
            this.files.add("xslFile", xslFile);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class UpdateFromFileMetadataBuilder
    extends RequestBuilder<Metadata, Metadata.Tokenizer, UpdateFromFileMetadataBuilder> {
        public UpdateFromFileMetadataBuilder(int id, FileHolder xmlFile) {
            super(Metadata.class, "metadata_metadata", "updateFromFile");
            this.params.add("id", id);
            this.files = new Files();
            this.files.add("xmlFile", xmlFile);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class UpdateMetadataBuilder
    extends RequestBuilder<Metadata, Metadata.Tokenizer, UpdateMetadataBuilder> {
        public UpdateMetadataBuilder(int id, String xmlData, int version) {
            super(Metadata.class, "metadata_metadata", "update");
            this.params.add("id", id);
            this.params.add("xmlData", xmlData);
            this.params.add("version", version);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void xmlData(String multirequestToken) {
            this.params.add("xmlData", multirequestToken);
        }

        public void version(String multirequestToken) {
            this.params.add("version", multirequestToken);
        }
    }

    public static class ServeMetadataBuilder
    extends ServeRequestBuilder {
        public ServeMetadataBuilder(int id) {
            super("metadata_metadata", "serve");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class ListMetadataBuilder
    extends ListResponseRequestBuilder<Metadata, Metadata.Tokenizer, ListMetadataBuilder> {
        public ListMetadataBuilder(MetadataFilter filter, FilterPager pager) {
            super(Metadata.class, "metadata_metadata", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class InvalidateMetadataBuilder
    extends NullRequestBuilder {
        public InvalidateMetadataBuilder(int id, int version) {
            super("metadata_metadata", "invalidate");
            this.params.add("id", id);
            this.params.add("version", version);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void version(String multirequestToken) {
            this.params.add("version", multirequestToken);
        }
    }

    public static class IndexMetadataBuilder
    extends RequestBuilder<Integer, String, IndexMetadataBuilder> {
        public IndexMetadataBuilder(String id, boolean shouldUpdate) {
            super(Integer.class, "metadata_metadata", "index");
            this.params.add("id", id);
            this.params.add("shouldUpdate", shouldUpdate);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void shouldUpdate(String multirequestToken) {
            this.params.add("shouldUpdate", multirequestToken);
        }
    }

    public static class GetMetadataBuilder
    extends RequestBuilder<Metadata, Metadata.Tokenizer, GetMetadataBuilder> {
        public GetMetadataBuilder(int id) {
            super(Metadata.class, "metadata_metadata", "get");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class DeleteMetadataBuilder
    extends NullRequestBuilder {
        public DeleteMetadataBuilder(int id) {
            super("metadata_metadata", "delete");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class AddFromUrlMetadataBuilder
    extends RequestBuilder<Metadata, Metadata.Tokenizer, AddFromUrlMetadataBuilder> {
        public AddFromUrlMetadataBuilder(int metadataProfileId, MetadataObjectType objectType, String objectId, String url) {
            super(Metadata.class, "metadata_metadata", "addFromUrl");
            this.params.add("metadataProfileId", metadataProfileId);
            this.params.add("objectType", objectType);
            this.params.add("objectId", objectId);
            this.params.add("url", url);
        }

        public void metadataProfileId(String multirequestToken) {
            this.params.add("metadataProfileId", multirequestToken);
        }

        public void objectType(String multirequestToken) {
            this.params.add("objectType", multirequestToken);
        }

        public void objectId(String multirequestToken) {
            this.params.add("objectId", multirequestToken);
        }

        public void url(String multirequestToken) {
            this.params.add("url", multirequestToken);
        }
    }

    public static class AddFromFileMetadataBuilder
    extends RequestBuilder<Metadata, Metadata.Tokenizer, AddFromFileMetadataBuilder> {
        public AddFromFileMetadataBuilder(int metadataProfileId, MetadataObjectType objectType, String objectId, FileHolder xmlFile) {
            super(Metadata.class, "metadata_metadata", "addFromFile");
            this.params.add("metadataProfileId", metadataProfileId);
            this.params.add("objectType", objectType);
            this.params.add("objectId", objectId);
            this.files = new Files();
            this.files.add("xmlFile", xmlFile);
        }

        public void metadataProfileId(String multirequestToken) {
            this.params.add("metadataProfileId", multirequestToken);
        }

        public void objectType(String multirequestToken) {
            this.params.add("objectType", multirequestToken);
        }

        public void objectId(String multirequestToken) {
            this.params.add("objectId", multirequestToken);
        }
    }

    public static class AddFromBulkMetadataBuilder
    extends RequestBuilder<Metadata, Metadata.Tokenizer, AddFromBulkMetadataBuilder> {
        public AddFromBulkMetadataBuilder(int metadataProfileId, MetadataObjectType objectType, String objectId, String url) {
            super(Metadata.class, "metadata_metadata", "addFromBulk");
            this.params.add("metadataProfileId", metadataProfileId);
            this.params.add("objectType", objectType);
            this.params.add("objectId", objectId);
            this.params.add("url", url);
        }

        public void metadataProfileId(String multirequestToken) {
            this.params.add("metadataProfileId", multirequestToken);
        }

        public void objectType(String multirequestToken) {
            this.params.add("objectType", multirequestToken);
        }

        public void objectId(String multirequestToken) {
            this.params.add("objectId", multirequestToken);
        }

        public void url(String multirequestToken) {
            this.params.add("url", multirequestToken);
        }
    }

    public static class AddMetadataBuilder
    extends RequestBuilder<Metadata, Metadata.Tokenizer, AddMetadataBuilder> {
        public AddMetadataBuilder(int metadataProfileId, MetadataObjectType objectType, String objectId, String xmlData) {
            super(Metadata.class, "metadata_metadata", "add");
            this.params.add("metadataProfileId", metadataProfileId);
            this.params.add("objectType", objectType);
            this.params.add("objectId", objectId);
            this.params.add("xmlData", xmlData);
        }

        public void metadataProfileId(String multirequestToken) {
            this.params.add("metadataProfileId", multirequestToken);
        }

        public void objectType(String multirequestToken) {
            this.params.add("objectType", multirequestToken);
        }

        public void objectId(String multirequestToken) {
            this.params.add("objectId", multirequestToken);
        }

        public void xmlData(String multirequestToken) {
            this.params.add("xmlData", multirequestToken);
        }
    }
}

