/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.enums.EntryServerNodeStatus;
import com.kaltura.client.enums.EntryServerNodeType;
import com.kaltura.client.enums.PlaybackProtocol;
import com.kaltura.client.enums.SourceType;
import com.kaltura.client.types.DataCenterContentResource;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.LiveEntry;
import com.kaltura.client.types.LiveStreamConfiguration;
import com.kaltura.client.types.LiveStreamDetails;
import com.kaltura.client.types.LiveStreamEntry;
import com.kaltura.client.types.LiveStreamEntryFilter;
import com.kaltura.client.types.RoomDetails;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class LiveStreamService {
    public static AddLiveStreamBuilder add(LiveStreamEntry liveStreamEntry) {
        return LiveStreamService.add(liveStreamEntry, null);
    }

    public static AddLiveStreamBuilder add(LiveStreamEntry liveStreamEntry, SourceType sourceType) {
        return new AddLiveStreamBuilder(liveStreamEntry, sourceType);
    }

    public static AddLiveStreamPushPublishConfigurationLiveStreamBuilder addLiveStreamPushPublishConfiguration(String entryId, PlaybackProtocol protocol) {
        return LiveStreamService.addLiveStreamPushPublishConfiguration(entryId, protocol, null);
    }

    public static AddLiveStreamPushPublishConfigurationLiveStreamBuilder addLiveStreamPushPublishConfiguration(String entryId, PlaybackProtocol protocol, String url) {
        return LiveStreamService.addLiveStreamPushPublishConfiguration(entryId, protocol, url, null);
    }

    public static AddLiveStreamPushPublishConfigurationLiveStreamBuilder addLiveStreamPushPublishConfiguration(String entryId, PlaybackProtocol protocol, String url, LiveStreamConfiguration liveStreamConfiguration) {
        return new AddLiveStreamPushPublishConfigurationLiveStreamBuilder(entryId, protocol, url, liveStreamConfiguration);
    }

    public static AllocateConferenceRoomLiveStreamBuilder allocateConferenceRoom(String entryId) {
        return LiveStreamService.allocateConferenceRoom(entryId, "");
    }

    public static AllocateConferenceRoomLiveStreamBuilder allocateConferenceRoom(String entryId, String env) {
        return new AllocateConferenceRoomLiveStreamBuilder(entryId, env);
    }

    public static AppendRecordingLiveStreamBuilder appendRecording(String entryId, String assetId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration) {
        return LiveStreamService.appendRecording(entryId, assetId, mediaServerIndex, resource, duration, false);
    }

    public static AppendRecordingLiveStreamBuilder appendRecording(String entryId, String assetId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration, boolean isLastChunk) {
        return new AppendRecordingLiveStreamBuilder(entryId, assetId, mediaServerIndex, resource, duration, isLastChunk);
    }

    public static ArchiveLiveStreamBuilder archive(String liveEntryId, String vodEntryId) {
        return new ArchiveLiveStreamBuilder(liveEntryId, vodEntryId);
    }

    public static AuthenticateLiveStreamBuilder authenticate(String entryId, String token) {
        return LiveStreamService.authenticate(entryId, token, null);
    }

    public static AuthenticateLiveStreamBuilder authenticate(String entryId, String token, String hostname) {
        return LiveStreamService.authenticate(entryId, token, hostname, null);
    }

    public static AuthenticateLiveStreamBuilder authenticate(String entryId, String token, String hostname, EntryServerNodeType mediaServerIndex) {
        return LiveStreamService.authenticate(entryId, token, hostname, mediaServerIndex, null);
    }

    public static AuthenticateLiveStreamBuilder authenticate(String entryId, String token, String hostname, EntryServerNodeType mediaServerIndex, String applicationName) {
        return new AuthenticateLiveStreamBuilder(entryId, token, hostname, mediaServerIndex, applicationName);
    }

    public static CreatePeriodicSyncPointsLiveStreamBuilder createPeriodicSyncPoints(String entryId, int interval, int duration) {
        return new CreatePeriodicSyncPointsLiveStreamBuilder(entryId, interval, duration);
    }

    public static CreateRecordedEntryLiveStreamBuilder createRecordedEntry(String entryId, EntryServerNodeType mediaServerIndex, EntryServerNodeStatus liveEntryStatus) {
        return new CreateRecordedEntryLiveStreamBuilder(entryId, mediaServerIndex, liveEntryStatus);
    }

    public static DeleteLiveStreamBuilder delete(String entryId) {
        return new DeleteLiveStreamBuilder(entryId);
    }

    public static FinishConfLiveStreamBuilder finishConf(String entryId) {
        return LiveStreamService.finishConf(entryId, Integer.MIN_VALUE);
    }

    public static FinishConfLiveStreamBuilder finishConf(String entryId, int serverNodeId) {
        return new FinishConfLiveStreamBuilder(entryId, serverNodeId);
    }

    public static GetLiveStreamBuilder get(String entryId) {
        return LiveStreamService.get(entryId, -1);
    }

    public static GetLiveStreamBuilder get(String entryId, int version) {
        return new GetLiveStreamBuilder(entryId, version);
    }

    public static GetDetailsLiveStreamBuilder getDetails(String id) {
        return new GetDetailsLiveStreamBuilder(id);
    }

    public static IsLiveLiveStreamBuilder isLive(String id) {
        return LiveStreamService.isLive(id, null);
    }

    public static IsLiveLiveStreamBuilder isLive(String id, PlaybackProtocol protocol) {
        return new IsLiveLiveStreamBuilder(id, protocol);
    }

    public static ListLiveStreamBuilder list() {
        return LiveStreamService.list(null);
    }

    public static ListLiveStreamBuilder list(LiveStreamEntryFilter filter) {
        return LiveStreamService.list(filter, null);
    }

    public static ListLiveStreamBuilder list(LiveStreamEntryFilter filter, FilterPager pager) {
        return new ListLiveStreamBuilder(filter, pager);
    }

    public static RegenerateStreamTokenLiveStreamBuilder regenerateStreamToken(String entryId) {
        return new RegenerateStreamTokenLiveStreamBuilder(entryId);
    }

    public static RegisterConfLiveStreamBuilder registerConf(String entryId) {
        return new RegisterConfLiveStreamBuilder(entryId);
    }

    public static RegisterMediaServerLiveStreamBuilder registerMediaServer(String entryId, String hostname, EntryServerNodeType mediaServerIndex) {
        return LiveStreamService.registerMediaServer(entryId, hostname, mediaServerIndex, null);
    }

    public static RegisterMediaServerLiveStreamBuilder registerMediaServer(String entryId, String hostname, EntryServerNodeType mediaServerIndex, String applicationName) {
        return LiveStreamService.registerMediaServer(entryId, hostname, mediaServerIndex, applicationName, EntryServerNodeStatus.get(1));
    }

    public static RegisterMediaServerLiveStreamBuilder registerMediaServer(String entryId, String hostname, EntryServerNodeType mediaServerIndex, String applicationName, EntryServerNodeStatus liveEntryStatus) {
        return LiveStreamService.registerMediaServer(entryId, hostname, mediaServerIndex, applicationName, liveEntryStatus, true);
    }

    public static RegisterMediaServerLiveStreamBuilder registerMediaServer(String entryId, String hostname, EntryServerNodeType mediaServerIndex, String applicationName, EntryServerNodeStatus liveEntryStatus, boolean shouldCreateRecordedEntry) {
        return new RegisterMediaServerLiveStreamBuilder(entryId, hostname, mediaServerIndex, applicationName, liveEntryStatus, shouldCreateRecordedEntry);
    }

    public static RemoveLiveStreamPushPublishConfigurationLiveStreamBuilder removeLiveStreamPushPublishConfiguration(String entryId, PlaybackProtocol protocol) {
        return new RemoveLiveStreamPushPublishConfigurationLiveStreamBuilder(entryId, protocol);
    }

    public static SetRecordedContentLiveStreamBuilder setRecordedContent(String entryId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration) {
        return LiveStreamService.setRecordedContent(entryId, mediaServerIndex, resource, duration, null);
    }

    public static SetRecordedContentLiveStreamBuilder setRecordedContent(String entryId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration, String recordedEntryId) {
        return LiveStreamService.setRecordedContent(entryId, mediaServerIndex, resource, duration, recordedEntryId, Integer.MIN_VALUE);
    }

    public static SetRecordedContentLiveStreamBuilder setRecordedContent(String entryId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration, String recordedEntryId, int flavorParamsId) {
        return new SetRecordedContentLiveStreamBuilder(entryId, mediaServerIndex, resource, duration, recordedEntryId, flavorParamsId);
    }

    public static UnregisterMediaServerLiveStreamBuilder unregisterMediaServer(String entryId, String hostname, EntryServerNodeType mediaServerIndex) {
        return new UnregisterMediaServerLiveStreamBuilder(entryId, hostname, mediaServerIndex);
    }

    public static UpdateLiveStreamBuilder update(String entryId, LiveStreamEntry liveStreamEntry) {
        return new UpdateLiveStreamBuilder(entryId, liveStreamEntry);
    }

    public static UpdateOfflineThumbnailFromUrlLiveStreamBuilder updateOfflineThumbnailFromUrl(String entryId, String url) {
        return new UpdateOfflineThumbnailFromUrlLiveStreamBuilder(entryId, url);
    }

    public static UpdateOfflineThumbnailJpegLiveStreamBuilder updateOfflineThumbnailJpeg(String entryId, File fileData) {
        return LiveStreamService.updateOfflineThumbnailJpeg(entryId, new FileHolder(fileData));
    }

    public static UpdateOfflineThumbnailJpegLiveStreamBuilder updateOfflineThumbnailJpeg(String entryId, InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return LiveStreamService.updateOfflineThumbnailJpeg(entryId, new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize));
    }

    public static UpdateOfflineThumbnailJpegLiveStreamBuilder updateOfflineThumbnailJpeg(String entryId, FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return LiveStreamService.updateOfflineThumbnailJpeg(entryId, new FileHolder(fileData, fileDataMimeType, fileDataName));
    }

    public static UpdateOfflineThumbnailJpegLiveStreamBuilder updateOfflineThumbnailJpeg(String entryId, FileHolder fileData) {
        return new UpdateOfflineThumbnailJpegLiveStreamBuilder(entryId, fileData);
    }

    public static ValidateRegisteredMediaServersLiveStreamBuilder validateRegisteredMediaServers(String entryId) {
        return new ValidateRegisteredMediaServersLiveStreamBuilder(entryId);
    }

    public static class ValidateRegisteredMediaServersLiveStreamBuilder
    extends NullRequestBuilder {
        public ValidateRegisteredMediaServersLiveStreamBuilder(String entryId) {
            super("livestream", "validateRegisteredMediaServers");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class UpdateOfflineThumbnailJpegLiveStreamBuilder
    extends RequestBuilder<LiveStreamEntry, LiveStreamEntry.Tokenizer, UpdateOfflineThumbnailJpegLiveStreamBuilder> {
        public UpdateOfflineThumbnailJpegLiveStreamBuilder(String entryId, FileHolder fileData) {
            super(LiveStreamEntry.class, "livestream", "updateOfflineThumbnailJpeg");
            this.params.add("entryId", entryId);
            this.files = new Files();
            this.files.add("fileData", fileData);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class UpdateOfflineThumbnailFromUrlLiveStreamBuilder
    extends RequestBuilder<LiveStreamEntry, LiveStreamEntry.Tokenizer, UpdateOfflineThumbnailFromUrlLiveStreamBuilder> {
        public UpdateOfflineThumbnailFromUrlLiveStreamBuilder(String entryId, String url) {
            super(LiveStreamEntry.class, "livestream", "updateOfflineThumbnailFromUrl");
            this.params.add("entryId", entryId);
            this.params.add("url", url);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void url(String multirequestToken) {
            this.params.add("url", multirequestToken);
        }
    }

    public static class UpdateLiveStreamBuilder
    extends RequestBuilder<LiveStreamEntry, LiveStreamEntry.Tokenizer, UpdateLiveStreamBuilder> {
        public UpdateLiveStreamBuilder(String entryId, LiveStreamEntry liveStreamEntry) {
            super(LiveStreamEntry.class, "livestream", "update");
            this.params.add("entryId", entryId);
            this.params.add("liveStreamEntry", liveStreamEntry);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class UnregisterMediaServerLiveStreamBuilder
    extends RequestBuilder<LiveEntry, LiveEntry.Tokenizer, UnregisterMediaServerLiveStreamBuilder> {
        public UnregisterMediaServerLiveStreamBuilder(String entryId, String hostname, EntryServerNodeType mediaServerIndex) {
            super(LiveEntry.class, "livestream", "unregisterMediaServer");
            this.params.add("entryId", entryId);
            this.params.add("hostname", hostname);
            this.params.add("mediaServerIndex", mediaServerIndex);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void hostname(String multirequestToken) {
            this.params.add("hostname", multirequestToken);
        }

        public void mediaServerIndex(String multirequestToken) {
            this.params.add("mediaServerIndex", multirequestToken);
        }
    }

    public static class SetRecordedContentLiveStreamBuilder
    extends RequestBuilder<LiveEntry, LiveEntry.Tokenizer, SetRecordedContentLiveStreamBuilder> {
        public SetRecordedContentLiveStreamBuilder(String entryId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration, String recordedEntryId, int flavorParamsId) {
            super(LiveEntry.class, "livestream", "setRecordedContent");
            this.params.add("entryId", entryId);
            this.params.add("mediaServerIndex", mediaServerIndex);
            this.params.add("resource", resource);
            this.params.add("duration", duration);
            this.params.add("recordedEntryId", recordedEntryId);
            this.params.add("flavorParamsId", flavorParamsId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void mediaServerIndex(String multirequestToken) {
            this.params.add("mediaServerIndex", multirequestToken);
        }

        public void duration(String multirequestToken) {
            this.params.add("duration", multirequestToken);
        }

        public void recordedEntryId(String multirequestToken) {
            this.params.add("recordedEntryId", multirequestToken);
        }

        public void flavorParamsId(String multirequestToken) {
            this.params.add("flavorParamsId", multirequestToken);
        }
    }

    public static class RemoveLiveStreamPushPublishConfigurationLiveStreamBuilder
    extends RequestBuilder<LiveStreamEntry, LiveStreamEntry.Tokenizer, RemoveLiveStreamPushPublishConfigurationLiveStreamBuilder> {
        public RemoveLiveStreamPushPublishConfigurationLiveStreamBuilder(String entryId, PlaybackProtocol protocol) {
            super(LiveStreamEntry.class, "livestream", "removeLiveStreamPushPublishConfiguration");
            this.params.add("entryId", entryId);
            this.params.add("protocol", protocol);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void protocol(String multirequestToken) {
            this.params.add("protocol", multirequestToken);
        }
    }

    public static class RegisterMediaServerLiveStreamBuilder
    extends RequestBuilder<LiveEntry, LiveEntry.Tokenizer, RegisterMediaServerLiveStreamBuilder> {
        public RegisterMediaServerLiveStreamBuilder(String entryId, String hostname, EntryServerNodeType mediaServerIndex, String applicationName, EntryServerNodeStatus liveEntryStatus, boolean shouldCreateRecordedEntry) {
            super(LiveEntry.class, "livestream", "registerMediaServer");
            this.params.add("entryId", entryId);
            this.params.add("hostname", hostname);
            this.params.add("mediaServerIndex", mediaServerIndex);
            this.params.add("applicationName", applicationName);
            this.params.add("liveEntryStatus", liveEntryStatus);
            this.params.add("shouldCreateRecordedEntry", shouldCreateRecordedEntry);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void hostname(String multirequestToken) {
            this.params.add("hostname", multirequestToken);
        }

        public void mediaServerIndex(String multirequestToken) {
            this.params.add("mediaServerIndex", multirequestToken);
        }

        public void applicationName(String multirequestToken) {
            this.params.add("applicationName", multirequestToken);
        }

        public void liveEntryStatus(String multirequestToken) {
            this.params.add("liveEntryStatus", multirequestToken);
        }

        public void shouldCreateRecordedEntry(String multirequestToken) {
            this.params.add("shouldCreateRecordedEntry", multirequestToken);
        }
    }

    public static class RegisterConfLiveStreamBuilder
    extends RequestBuilder<Boolean, String, RegisterConfLiveStreamBuilder> {
        public RegisterConfLiveStreamBuilder(String entryId) {
            super(Boolean.class, "livestream", "registerConf");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class RegenerateStreamTokenLiveStreamBuilder
    extends RequestBuilder<LiveEntry, LiveEntry.Tokenizer, RegenerateStreamTokenLiveStreamBuilder> {
        public RegenerateStreamTokenLiveStreamBuilder(String entryId) {
            super(LiveEntry.class, "livestream", "regenerateStreamToken");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ListLiveStreamBuilder
    extends ListResponseRequestBuilder<LiveStreamEntry, LiveStreamEntry.Tokenizer, ListLiveStreamBuilder> {
        public ListLiveStreamBuilder(LiveStreamEntryFilter filter, FilterPager pager) {
            super(LiveStreamEntry.class, "livestream", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class IsLiveLiveStreamBuilder
    extends RequestBuilder<Boolean, String, IsLiveLiveStreamBuilder> {
        public IsLiveLiveStreamBuilder(String id, PlaybackProtocol protocol) {
            super(Boolean.class, "livestream", "isLive");
            this.params.add("id", id);
            this.params.add("protocol", protocol);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void protocol(String multirequestToken) {
            this.params.add("protocol", multirequestToken);
        }
    }

    public static class GetDetailsLiveStreamBuilder
    extends RequestBuilder<LiveStreamDetails, LiveStreamDetails.Tokenizer, GetDetailsLiveStreamBuilder> {
        public GetDetailsLiveStreamBuilder(String id) {
            super(LiveStreamDetails.class, "livestream", "getDetails");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class GetLiveStreamBuilder
    extends RequestBuilder<LiveStreamEntry, LiveStreamEntry.Tokenizer, GetLiveStreamBuilder> {
        public GetLiveStreamBuilder(String entryId, int version) {
            super(LiveStreamEntry.class, "livestream", "get");
            this.params.add("entryId", entryId);
            this.params.add("version", version);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void version(String multirequestToken) {
            this.params.add("version", multirequestToken);
        }
    }

    public static class FinishConfLiveStreamBuilder
    extends RequestBuilder<Boolean, String, FinishConfLiveStreamBuilder> {
        public FinishConfLiveStreamBuilder(String entryId, int serverNodeId) {
            super(Boolean.class, "livestream", "finishConf");
            this.params.add("entryId", entryId);
            this.params.add("serverNodeId", serverNodeId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void serverNodeId(String multirequestToken) {
            this.params.add("serverNodeId", multirequestToken);
        }
    }

    public static class DeleteLiveStreamBuilder
    extends NullRequestBuilder {
        public DeleteLiveStreamBuilder(String entryId) {
            super("livestream", "delete");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class CreateRecordedEntryLiveStreamBuilder
    extends RequestBuilder<LiveEntry, LiveEntry.Tokenizer, CreateRecordedEntryLiveStreamBuilder> {
        public CreateRecordedEntryLiveStreamBuilder(String entryId, EntryServerNodeType mediaServerIndex, EntryServerNodeStatus liveEntryStatus) {
            super(LiveEntry.class, "livestream", "createRecordedEntry");
            this.params.add("entryId", entryId);
            this.params.add("mediaServerIndex", mediaServerIndex);
            this.params.add("liveEntryStatus", liveEntryStatus);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void mediaServerIndex(String multirequestToken) {
            this.params.add("mediaServerIndex", multirequestToken);
        }

        public void liveEntryStatus(String multirequestToken) {
            this.params.add("liveEntryStatus", multirequestToken);
        }
    }

    public static class CreatePeriodicSyncPointsLiveStreamBuilder
    extends NullRequestBuilder {
        public CreatePeriodicSyncPointsLiveStreamBuilder(String entryId, int interval, int duration) {
            super("livestream", "createPeriodicSyncPoints");
            this.params.add("entryId", entryId);
            this.params.add("interval", interval);
            this.params.add("duration", duration);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void interval(String multirequestToken) {
            this.params.add("interval", multirequestToken);
        }

        public void duration(String multirequestToken) {
            this.params.add("duration", multirequestToken);
        }
    }

    public static class AuthenticateLiveStreamBuilder
    extends RequestBuilder<LiveStreamEntry, LiveStreamEntry.Tokenizer, AuthenticateLiveStreamBuilder> {
        public AuthenticateLiveStreamBuilder(String entryId, String token, String hostname, EntryServerNodeType mediaServerIndex, String applicationName) {
            super(LiveStreamEntry.class, "livestream", "authenticate");
            this.params.add("entryId", entryId);
            this.params.add("token", token);
            this.params.add("hostname", hostname);
            this.params.add("mediaServerIndex", mediaServerIndex);
            this.params.add("applicationName", applicationName);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void token(String multirequestToken) {
            this.params.add("token", multirequestToken);
        }

        public void hostname(String multirequestToken) {
            this.params.add("hostname", multirequestToken);
        }

        public void mediaServerIndex(String multirequestToken) {
            this.params.add("mediaServerIndex", multirequestToken);
        }

        public void applicationName(String multirequestToken) {
            this.params.add("applicationName", multirequestToken);
        }
    }

    public static class ArchiveLiveStreamBuilder
    extends RequestBuilder<Boolean, String, ArchiveLiveStreamBuilder> {
        public ArchiveLiveStreamBuilder(String liveEntryId, String vodEntryId) {
            super(Boolean.class, "livestream", "archive");
            this.params.add("liveEntryId", liveEntryId);
            this.params.add("vodEntryId", vodEntryId);
        }

        public void liveEntryId(String multirequestToken) {
            this.params.add("liveEntryId", multirequestToken);
        }

        public void vodEntryId(String multirequestToken) {
            this.params.add("vodEntryId", multirequestToken);
        }
    }

    public static class AppendRecordingLiveStreamBuilder
    extends RequestBuilder<LiveEntry, LiveEntry.Tokenizer, AppendRecordingLiveStreamBuilder> {
        public AppendRecordingLiveStreamBuilder(String entryId, String assetId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration, boolean isLastChunk) {
            super(LiveEntry.class, "livestream", "appendRecording");
            this.params.add("entryId", entryId);
            this.params.add("assetId", assetId);
            this.params.add("mediaServerIndex", mediaServerIndex);
            this.params.add("resource", resource);
            this.params.add("duration", duration);
            this.params.add("isLastChunk", isLastChunk);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void assetId(String multirequestToken) {
            this.params.add("assetId", multirequestToken);
        }

        public void mediaServerIndex(String multirequestToken) {
            this.params.add("mediaServerIndex", multirequestToken);
        }

        public void duration(String multirequestToken) {
            this.params.add("duration", multirequestToken);
        }

        public void isLastChunk(String multirequestToken) {
            this.params.add("isLastChunk", multirequestToken);
        }
    }

    public static class AllocateConferenceRoomLiveStreamBuilder
    extends RequestBuilder<RoomDetails, RoomDetails.Tokenizer, AllocateConferenceRoomLiveStreamBuilder> {
        public AllocateConferenceRoomLiveStreamBuilder(String entryId, String env) {
            super(RoomDetails.class, "livestream", "allocateConferenceRoom");
            this.params.add("entryId", entryId);
            this.params.add("env", env);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void env(String multirequestToken) {
            this.params.add("env", multirequestToken);
        }
    }

    public static class AddLiveStreamPushPublishConfigurationLiveStreamBuilder
    extends RequestBuilder<LiveStreamEntry, LiveStreamEntry.Tokenizer, AddLiveStreamPushPublishConfigurationLiveStreamBuilder> {
        public AddLiveStreamPushPublishConfigurationLiveStreamBuilder(String entryId, PlaybackProtocol protocol, String url, LiveStreamConfiguration liveStreamConfiguration) {
            super(LiveStreamEntry.class, "livestream", "addLiveStreamPushPublishConfiguration");
            this.params.add("entryId", entryId);
            this.params.add("protocol", protocol);
            this.params.add("url", url);
            this.params.add("liveStreamConfiguration", liveStreamConfiguration);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void protocol(String multirequestToken) {
            this.params.add("protocol", multirequestToken);
        }

        public void url(String multirequestToken) {
            this.params.add("url", multirequestToken);
        }
    }

    public static class AddLiveStreamBuilder
    extends RequestBuilder<LiveStreamEntry, LiveStreamEntry.Tokenizer, AddLiveStreamBuilder> {
        public AddLiveStreamBuilder(LiveStreamEntry liveStreamEntry, SourceType sourceType) {
            super(LiveStreamEntry.class, "livestream", "add");
            this.params.add("liveStreamEntry", liveStreamEntry);
            this.params.add("sourceType", sourceType);
        }

        public void sourceType(String multirequestToken) {
            this.params.add("sourceType", multirequestToken);
        }
    }
}

