/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.enums.EntryServerNodeStatus;
import com.kaltura.client.enums.EntryServerNodeType;
import com.kaltura.client.types.DataCenterContentResource;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.LiveChannel;
import com.kaltura.client.types.LiveChannelFilter;
import com.kaltura.client.types.LiveEntry;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class LiveChannelService {
    public static AddLiveChannelBuilder add(LiveChannel liveChannel) {
        return new AddLiveChannelBuilder(liveChannel);
    }

    public static AppendRecordingLiveChannelBuilder appendRecording(String entryId, String assetId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration) {
        return LiveChannelService.appendRecording(entryId, assetId, mediaServerIndex, resource, duration, false);
    }

    public static AppendRecordingLiveChannelBuilder appendRecording(String entryId, String assetId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration, boolean isLastChunk) {
        return new AppendRecordingLiveChannelBuilder(entryId, assetId, mediaServerIndex, resource, duration, isLastChunk);
    }

    public static CreateRecordedEntryLiveChannelBuilder createRecordedEntry(String entryId, EntryServerNodeType mediaServerIndex, EntryServerNodeStatus liveEntryStatus) {
        return new CreateRecordedEntryLiveChannelBuilder(entryId, mediaServerIndex, liveEntryStatus);
    }

    public static DeleteLiveChannelBuilder delete(String id) {
        return new DeleteLiveChannelBuilder(id);
    }

    public static GetLiveChannelBuilder get(String id) {
        return new GetLiveChannelBuilder(id);
    }

    public static IsLiveLiveChannelBuilder isLive(String id) {
        return new IsLiveLiveChannelBuilder(id);
    }

    public static ListLiveChannelBuilder list() {
        return LiveChannelService.list(null);
    }

    public static ListLiveChannelBuilder list(LiveChannelFilter filter) {
        return LiveChannelService.list(filter, null);
    }

    public static ListLiveChannelBuilder list(LiveChannelFilter filter, FilterPager pager) {
        return new ListLiveChannelBuilder(filter, pager);
    }

    public static RegisterMediaServerLiveChannelBuilder registerMediaServer(String entryId, String hostname, EntryServerNodeType mediaServerIndex) {
        return LiveChannelService.registerMediaServer(entryId, hostname, mediaServerIndex, null);
    }

    public static RegisterMediaServerLiveChannelBuilder registerMediaServer(String entryId, String hostname, EntryServerNodeType mediaServerIndex, String applicationName) {
        return LiveChannelService.registerMediaServer(entryId, hostname, mediaServerIndex, applicationName, EntryServerNodeStatus.get(1));
    }

    public static RegisterMediaServerLiveChannelBuilder registerMediaServer(String entryId, String hostname, EntryServerNodeType mediaServerIndex, String applicationName, EntryServerNodeStatus liveEntryStatus) {
        return LiveChannelService.registerMediaServer(entryId, hostname, mediaServerIndex, applicationName, liveEntryStatus, true);
    }

    public static RegisterMediaServerLiveChannelBuilder registerMediaServer(String entryId, String hostname, EntryServerNodeType mediaServerIndex, String applicationName, EntryServerNodeStatus liveEntryStatus, boolean shouldCreateRecordedEntry) {
        return new RegisterMediaServerLiveChannelBuilder(entryId, hostname, mediaServerIndex, applicationName, liveEntryStatus, shouldCreateRecordedEntry);
    }

    public static SetRecordedContentLiveChannelBuilder setRecordedContent(String entryId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration) {
        return LiveChannelService.setRecordedContent(entryId, mediaServerIndex, resource, duration, null);
    }

    public static SetRecordedContentLiveChannelBuilder setRecordedContent(String entryId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration, String recordedEntryId) {
        return LiveChannelService.setRecordedContent(entryId, mediaServerIndex, resource, duration, recordedEntryId, Integer.MIN_VALUE);
    }

    public static SetRecordedContentLiveChannelBuilder setRecordedContent(String entryId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration, String recordedEntryId, int flavorParamsId) {
        return new SetRecordedContentLiveChannelBuilder(entryId, mediaServerIndex, resource, duration, recordedEntryId, flavorParamsId);
    }

    public static UnregisterMediaServerLiveChannelBuilder unregisterMediaServer(String entryId, String hostname, EntryServerNodeType mediaServerIndex) {
        return new UnregisterMediaServerLiveChannelBuilder(entryId, hostname, mediaServerIndex);
    }

    public static UpdateLiveChannelBuilder update(String id, LiveChannel liveChannel) {
        return new UpdateLiveChannelBuilder(id, liveChannel);
    }

    public static ValidateRegisteredMediaServersLiveChannelBuilder validateRegisteredMediaServers(String entryId) {
        return new ValidateRegisteredMediaServersLiveChannelBuilder(entryId);
    }

    public static class ValidateRegisteredMediaServersLiveChannelBuilder
    extends NullRequestBuilder {
        public ValidateRegisteredMediaServersLiveChannelBuilder(String entryId) {
            super("livechannel", "validateRegisteredMediaServers");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class UpdateLiveChannelBuilder
    extends RequestBuilder<LiveChannel, LiveChannel.Tokenizer, UpdateLiveChannelBuilder> {
        public UpdateLiveChannelBuilder(String id, LiveChannel liveChannel) {
            super(LiveChannel.class, "livechannel", "update");
            this.params.add("id", id);
            this.params.add("liveChannel", liveChannel);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class UnregisterMediaServerLiveChannelBuilder
    extends RequestBuilder<LiveEntry, LiveEntry.Tokenizer, UnregisterMediaServerLiveChannelBuilder> {
        public UnregisterMediaServerLiveChannelBuilder(String entryId, String hostname, EntryServerNodeType mediaServerIndex) {
            super(LiveEntry.class, "livechannel", "unregisterMediaServer");
            this.params.add("entryId", entryId);
            this.params.add("hostname", hostname);
            this.params.add("mediaServerIndex", mediaServerIndex);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void hostname(String multirequestToken) {
            this.params.add("hostname", multirequestToken);
        }

        public void mediaServerIndex(String multirequestToken) {
            this.params.add("mediaServerIndex", multirequestToken);
        }
    }

    public static class SetRecordedContentLiveChannelBuilder
    extends RequestBuilder<LiveEntry, LiveEntry.Tokenizer, SetRecordedContentLiveChannelBuilder> {
        public SetRecordedContentLiveChannelBuilder(String entryId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration, String recordedEntryId, int flavorParamsId) {
            super(LiveEntry.class, "livechannel", "setRecordedContent");
            this.params.add("entryId", entryId);
            this.params.add("mediaServerIndex", mediaServerIndex);
            this.params.add("resource", resource);
            this.params.add("duration", duration);
            this.params.add("recordedEntryId", recordedEntryId);
            this.params.add("flavorParamsId", flavorParamsId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void mediaServerIndex(String multirequestToken) {
            this.params.add("mediaServerIndex", multirequestToken);
        }

        public void duration(String multirequestToken) {
            this.params.add("duration", multirequestToken);
        }

        public void recordedEntryId(String multirequestToken) {
            this.params.add("recordedEntryId", multirequestToken);
        }

        public void flavorParamsId(String multirequestToken) {
            this.params.add("flavorParamsId", multirequestToken);
        }
    }

    public static class RegisterMediaServerLiveChannelBuilder
    extends RequestBuilder<LiveEntry, LiveEntry.Tokenizer, RegisterMediaServerLiveChannelBuilder> {
        public RegisterMediaServerLiveChannelBuilder(String entryId, String hostname, EntryServerNodeType mediaServerIndex, String applicationName, EntryServerNodeStatus liveEntryStatus, boolean shouldCreateRecordedEntry) {
            super(LiveEntry.class, "livechannel", "registerMediaServer");
            this.params.add("entryId", entryId);
            this.params.add("hostname", hostname);
            this.params.add("mediaServerIndex", mediaServerIndex);
            this.params.add("applicationName", applicationName);
            this.params.add("liveEntryStatus", liveEntryStatus);
            this.params.add("shouldCreateRecordedEntry", shouldCreateRecordedEntry);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void hostname(String multirequestToken) {
            this.params.add("hostname", multirequestToken);
        }

        public void mediaServerIndex(String multirequestToken) {
            this.params.add("mediaServerIndex", multirequestToken);
        }

        public void applicationName(String multirequestToken) {
            this.params.add("applicationName", multirequestToken);
        }

        public void liveEntryStatus(String multirequestToken) {
            this.params.add("liveEntryStatus", multirequestToken);
        }

        public void shouldCreateRecordedEntry(String multirequestToken) {
            this.params.add("shouldCreateRecordedEntry", multirequestToken);
        }
    }

    public static class ListLiveChannelBuilder
    extends ListResponseRequestBuilder<LiveChannel, LiveChannel.Tokenizer, ListLiveChannelBuilder> {
        public ListLiveChannelBuilder(LiveChannelFilter filter, FilterPager pager) {
            super(LiveChannel.class, "livechannel", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class IsLiveLiveChannelBuilder
    extends RequestBuilder<Boolean, String, IsLiveLiveChannelBuilder> {
        public IsLiveLiveChannelBuilder(String id) {
            super(Boolean.class, "livechannel", "isLive");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class GetLiveChannelBuilder
    extends RequestBuilder<LiveChannel, LiveChannel.Tokenizer, GetLiveChannelBuilder> {
        public GetLiveChannelBuilder(String id) {
            super(LiveChannel.class, "livechannel", "get");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class DeleteLiveChannelBuilder
    extends NullRequestBuilder {
        public DeleteLiveChannelBuilder(String id) {
            super("livechannel", "delete");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class CreateRecordedEntryLiveChannelBuilder
    extends RequestBuilder<LiveEntry, LiveEntry.Tokenizer, CreateRecordedEntryLiveChannelBuilder> {
        public CreateRecordedEntryLiveChannelBuilder(String entryId, EntryServerNodeType mediaServerIndex, EntryServerNodeStatus liveEntryStatus) {
            super(LiveEntry.class, "livechannel", "createRecordedEntry");
            this.params.add("entryId", entryId);
            this.params.add("mediaServerIndex", mediaServerIndex);
            this.params.add("liveEntryStatus", liveEntryStatus);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void mediaServerIndex(String multirequestToken) {
            this.params.add("mediaServerIndex", multirequestToken);
        }

        public void liveEntryStatus(String multirequestToken) {
            this.params.add("liveEntryStatus", multirequestToken);
        }
    }

    public static class AppendRecordingLiveChannelBuilder
    extends RequestBuilder<LiveEntry, LiveEntry.Tokenizer, AppendRecordingLiveChannelBuilder> {
        public AppendRecordingLiveChannelBuilder(String entryId, String assetId, EntryServerNodeType mediaServerIndex, DataCenterContentResource resource, double duration, boolean isLastChunk) {
            super(LiveEntry.class, "livechannel", "appendRecording");
            this.params.add("entryId", entryId);
            this.params.add("assetId", assetId);
            this.params.add("mediaServerIndex", mediaServerIndex);
            this.params.add("resource", resource);
            this.params.add("duration", duration);
            this.params.add("isLastChunk", isLastChunk);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void assetId(String multirequestToken) {
            this.params.add("assetId", multirequestToken);
        }

        public void mediaServerIndex(String multirequestToken) {
            this.params.add("mediaServerIndex", multirequestToken);
        }

        public void duration(String multirequestToken) {
            this.params.add("duration", multirequestToken);
        }

        public void isLastChunk(String multirequestToken) {
            this.params.add("isLastChunk", multirequestToken);
        }
    }

    public static class AddLiveChannelBuilder
    extends RequestBuilder<LiveChannel, LiveChannel.Tokenizer, AddLiveChannelBuilder> {
        public AddLiveChannelBuilder(LiveChannel liveChannel) {
            super(LiveChannel.class, "livechannel", "add");
            this.params.add("liveChannel", liveChannel);
        }
    }
}

