/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.BulkUpload;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.GroupUser;
import com.kaltura.client.types.GroupUserFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class GroupUserService {
    public static AddGroupUserBuilder add(GroupUser groupUser) {
        return new AddGroupUserBuilder(groupUser);
    }

    public static DeleteGroupUserBuilder delete(String userId, String groupId) {
        return new DeleteGroupUserBuilder(userId, groupId);
    }

    public static ListGroupUserBuilder list() {
        return GroupUserService.list(null);
    }

    public static ListGroupUserBuilder list(GroupUserFilter filter) {
        return GroupUserService.list(filter, null);
    }

    public static ListGroupUserBuilder list(GroupUserFilter filter, FilterPager pager) {
        return new ListGroupUserBuilder(filter, pager);
    }

    public static SyncGroupUserBuilder sync(String userId) {
        return GroupUserService.sync(userId, null);
    }

    public static SyncGroupUserBuilder sync(String userId, String groupIds) {
        return GroupUserService.sync(userId, groupIds, true);
    }

    public static SyncGroupUserBuilder sync(String userId, String groupIds, boolean removeFromExistingGroups) {
        return GroupUserService.sync(userId, groupIds, removeFromExistingGroups, true);
    }

    public static SyncGroupUserBuilder sync(String userId, String groupIds, boolean removeFromExistingGroups, boolean createNewGroups) {
        return new SyncGroupUserBuilder(userId, groupIds, removeFromExistingGroups, createNewGroups);
    }

    public static UpdateGroupUserBuilder update(String groupUserId, GroupUser groupUser) {
        return new UpdateGroupUserBuilder(groupUserId, groupUser);
    }

    public static class UpdateGroupUserBuilder
    extends RequestBuilder<GroupUser, GroupUser.Tokenizer, UpdateGroupUserBuilder> {
        public UpdateGroupUserBuilder(String groupUserId, GroupUser groupUser) {
            super(GroupUser.class, "groupuser", "update");
            this.params.add("groupUserId", groupUserId);
            this.params.add("groupUser", groupUser);
        }

        public void groupUserId(String multirequestToken) {
            this.params.add("groupUserId", multirequestToken);
        }
    }

    public static class SyncGroupUserBuilder
    extends RequestBuilder<BulkUpload, BulkUpload.Tokenizer, SyncGroupUserBuilder> {
        public SyncGroupUserBuilder(String userId, String groupIds, boolean removeFromExistingGroups, boolean createNewGroups) {
            super(BulkUpload.class, "groupuser", "sync");
            this.params.add("userId", userId);
            this.params.add("groupIds", groupIds);
            this.params.add("removeFromExistingGroups", removeFromExistingGroups);
            this.params.add("createNewGroups", createNewGroups);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }

        public void groupIds(String multirequestToken) {
            this.params.add("groupIds", multirequestToken);
        }

        public void removeFromExistingGroups(String multirequestToken) {
            this.params.add("removeFromExistingGroups", multirequestToken);
        }

        public void createNewGroups(String multirequestToken) {
            this.params.add("createNewGroups", multirequestToken);
        }
    }

    public static class ListGroupUserBuilder
    extends ListResponseRequestBuilder<GroupUser, GroupUser.Tokenizer, ListGroupUserBuilder> {
        public ListGroupUserBuilder(GroupUserFilter filter, FilterPager pager) {
            super(GroupUser.class, "groupuser", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class DeleteGroupUserBuilder
    extends NullRequestBuilder {
        public DeleteGroupUserBuilder(String userId, String groupId) {
            super("groupuser", "delete");
            this.params.add("userId", userId);
            this.params.add("groupId", groupId);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }

        public void groupId(String multirequestToken) {
            this.params.add("groupId", multirequestToken);
        }
    }

    public static class AddGroupUserBuilder
    extends RequestBuilder<GroupUser, GroupUser.Tokenizer, AddGroupUserBuilder> {
        public AddGroupUserBuilder(GroupUser groupUser) {
            super(GroupUser.class, "groupuser", "add");
            this.params.add("groupUser", groupUser);
        }
    }
}

