/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.Group;
import com.kaltura.client.types.GroupFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class GroupService {
    public static AddGroupBuilder add(Group group) {
        return new AddGroupBuilder(group);
    }

    public static CloneGroupBuilder clone(String originalGroupId, String newGroupId) {
        return GroupService.clone(originalGroupId, newGroupId, null);
    }

    public static CloneGroupBuilder clone(String originalGroupId, String newGroupId, String newGroupName) {
        return new CloneGroupBuilder(originalGroupId, newGroupId, newGroupName);
    }

    public static DeleteGroupBuilder delete(String groupId) {
        return new DeleteGroupBuilder(groupId);
    }

    public static GetGroupBuilder get(String groupId) {
        return new GetGroupBuilder(groupId);
    }

    public static ListGroupBuilder list() {
        return GroupService.list(null);
    }

    public static ListGroupBuilder list(GroupFilter filter) {
        return GroupService.list(filter, null);
    }

    public static ListGroupBuilder list(GroupFilter filter, FilterPager pager) {
        return new ListGroupBuilder(filter, pager);
    }

    public static UpdateGroupBuilder update(String groupId, Group group) {
        return new UpdateGroupBuilder(groupId, group);
    }

    public static class UpdateGroupBuilder
    extends RequestBuilder<Group, Group.Tokenizer, UpdateGroupBuilder> {
        public UpdateGroupBuilder(String groupId, Group group) {
            super(Group.class, "group_group", "update");
            this.params.add("groupId", groupId);
            this.params.add("group", group);
        }

        public void groupId(String multirequestToken) {
            this.params.add("groupId", multirequestToken);
        }
    }

    public static class ListGroupBuilder
    extends ListResponseRequestBuilder<Group, Group.Tokenizer, ListGroupBuilder> {
        public ListGroupBuilder(GroupFilter filter, FilterPager pager) {
            super(Group.class, "group_group", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetGroupBuilder
    extends RequestBuilder<Group, Group.Tokenizer, GetGroupBuilder> {
        public GetGroupBuilder(String groupId) {
            super(Group.class, "group_group", "get");
            this.params.add("groupId", groupId);
        }

        public void groupId(String multirequestToken) {
            this.params.add("groupId", multirequestToken);
        }
    }

    public static class DeleteGroupBuilder
    extends RequestBuilder<Group, Group.Tokenizer, DeleteGroupBuilder> {
        public DeleteGroupBuilder(String groupId) {
            super(Group.class, "group_group", "delete");
            this.params.add("groupId", groupId);
        }

        public void groupId(String multirequestToken) {
            this.params.add("groupId", multirequestToken);
        }
    }

    public static class CloneGroupBuilder
    extends RequestBuilder<Group, Group.Tokenizer, CloneGroupBuilder> {
        public CloneGroupBuilder(String originalGroupId, String newGroupId, String newGroupName) {
            super(Group.class, "group_group", "clone");
            this.params.add("originalGroupId", originalGroupId);
            this.params.add("newGroupId", newGroupId);
            this.params.add("newGroupName", newGroupName);
        }

        public void originalGroupId(String multirequestToken) {
            this.params.add("originalGroupId", multirequestToken);
        }

        public void newGroupId(String multirequestToken) {
            this.params.add("newGroupId", multirequestToken);
        }

        public void newGroupName(String multirequestToken) {
            this.params.add("newGroupName", multirequestToken);
        }
    }

    public static class AddGroupBuilder
    extends RequestBuilder<Group, Group.Tokenizer, AddGroupBuilder> {
        public AddGroupBuilder(Group group) {
            super(Group.class, "group_group", "add");
            this.params.add("group", group);
        }
    }
}

