/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.DataEntry;
import com.kaltura.client.types.DataEntryFilter;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.GenericDataCenterContentResource;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.request.ServeRequestBuilder;

public class DataService {
    public static AddDataBuilder add(DataEntry dataEntry) {
        return new AddDataBuilder(dataEntry);
    }

    public static AddContentDataBuilder addContent(String entryId, GenericDataCenterContentResource resource) {
        return new AddContentDataBuilder(entryId, resource);
    }

    public static DeleteDataBuilder delete(String entryId) {
        return new DeleteDataBuilder(entryId);
    }

    public static GetDataBuilder get(String entryId) {
        return DataService.get(entryId, -1);
    }

    public static GetDataBuilder get(String entryId, int version) {
        return new GetDataBuilder(entryId, version);
    }

    public static ListDataBuilder list() {
        return DataService.list(null);
    }

    public static ListDataBuilder list(DataEntryFilter filter) {
        return DataService.list(filter, null);
    }

    public static ListDataBuilder list(DataEntryFilter filter, FilterPager pager) {
        return new ListDataBuilder(filter, pager);
    }

    public static ServeDataBuilder serve(String entryId) {
        return DataService.serve(entryId, -1);
    }

    public static ServeDataBuilder serve(String entryId, int version) {
        return DataService.serve(entryId, version, false);
    }

    public static ServeDataBuilder serve(String entryId, int version, boolean forceProxy) {
        return new ServeDataBuilder(entryId, version, forceProxy);
    }

    public static UpdateDataBuilder update(String entryId, DataEntry documentEntry) {
        return new UpdateDataBuilder(entryId, documentEntry);
    }

    public static class UpdateDataBuilder
    extends RequestBuilder<DataEntry, DataEntry.Tokenizer, UpdateDataBuilder> {
        public UpdateDataBuilder(String entryId, DataEntry documentEntry) {
            super(DataEntry.class, "data", "update");
            this.params.add("entryId", entryId);
            this.params.add("documentEntry", documentEntry);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ServeDataBuilder
    extends ServeRequestBuilder {
        public ServeDataBuilder(String entryId, int version, boolean forceProxy) {
            super("data", "serve");
            this.params.add("entryId", entryId);
            this.params.add("version", version);
            this.params.add("forceProxy", forceProxy);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void version(String multirequestToken) {
            this.params.add("version", multirequestToken);
        }

        public void forceProxy(String multirequestToken) {
            this.params.add("forceProxy", multirequestToken);
        }
    }

    public static class ListDataBuilder
    extends ListResponseRequestBuilder<DataEntry, DataEntry.Tokenizer, ListDataBuilder> {
        public ListDataBuilder(DataEntryFilter filter, FilterPager pager) {
            super(DataEntry.class, "data", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetDataBuilder
    extends RequestBuilder<DataEntry, DataEntry.Tokenizer, GetDataBuilder> {
        public GetDataBuilder(String entryId, int version) {
            super(DataEntry.class, "data", "get");
            this.params.add("entryId", entryId);
            this.params.add("version", version);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void version(String multirequestToken) {
            this.params.add("version", multirequestToken);
        }
    }

    public static class DeleteDataBuilder
    extends NullRequestBuilder {
        public DeleteDataBuilder(String entryId) {
            super("data", "delete");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class AddContentDataBuilder
    extends RequestBuilder<String, String, AddContentDataBuilder> {
        public AddContentDataBuilder(String entryId, GenericDataCenterContentResource resource) {
            super(String.class, "data", "addContent");
            this.params.add("entryId", entryId);
            this.params.add("resource", resource);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class AddDataBuilder
    extends RequestBuilder<DataEntry, DataEntry.Tokenizer, AddDataBuilder> {
        public AddDataBuilder(DataEntry dataEntry) {
            super(DataEntry.class, "data", "add");
            this.params.add("dataEntry", dataEntry);
        }
    }
}

