/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.enums.CuePointStatus;
import com.kaltura.client.types.CuePoint;
import com.kaltura.client.types.CuePointFilter;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.request.ServeRequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class CuePointService {
    public static AddCuePointBuilder add(CuePoint cuePoint) {
        return new AddCuePointBuilder(cuePoint);
    }

    public static AddFromBulkCuePointBuilder addFromBulk(File fileData) {
        return CuePointService.addFromBulk(new FileHolder(fileData));
    }

    public static AddFromBulkCuePointBuilder addFromBulk(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return CuePointService.addFromBulk(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize));
    }

    public static AddFromBulkCuePointBuilder addFromBulk(FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return CuePointService.addFromBulk(new FileHolder(fileData, fileDataMimeType, fileDataName));
    }

    public static AddFromBulkCuePointBuilder addFromBulk(FileHolder fileData) {
        return new AddFromBulkCuePointBuilder(fileData);
    }

    public static CloneCuePointBuilder clone(String id, String entryId) {
        return new CloneCuePointBuilder(id, entryId);
    }

    public static CountCuePointBuilder count() {
        return CuePointService.count(null);
    }

    public static CountCuePointBuilder count(CuePointFilter filter) {
        return new CountCuePointBuilder(filter);
    }

    public static DeleteCuePointBuilder delete(String id) {
        return new DeleteCuePointBuilder(id);
    }

    public static GetCuePointBuilder get(String id) {
        return new GetCuePointBuilder(id);
    }

    public static ListCuePointBuilder list() {
        return CuePointService.list(null);
    }

    public static ListCuePointBuilder list(CuePointFilter filter) {
        return CuePointService.list(filter, null);
    }

    public static ListCuePointBuilder list(CuePointFilter filter, FilterPager pager) {
        return new ListCuePointBuilder(filter, pager);
    }

    public static ServeBulkCuePointBuilder serveBulk() {
        return CuePointService.serveBulk(null);
    }

    public static ServeBulkCuePointBuilder serveBulk(CuePointFilter filter) {
        return CuePointService.serveBulk(filter, null);
    }

    public static ServeBulkCuePointBuilder serveBulk(CuePointFilter filter, FilterPager pager) {
        return new ServeBulkCuePointBuilder(filter, pager);
    }

    public static UpdateCuePointBuilder update(String id, CuePoint cuePoint) {
        return new UpdateCuePointBuilder(id, cuePoint);
    }

    public static UpdateCuePointsTimesCuePointBuilder updateCuePointsTimes(String id, int startTime) {
        return CuePointService.updateCuePointsTimes(id, startTime, Integer.MIN_VALUE);
    }

    public static UpdateCuePointsTimesCuePointBuilder updateCuePointsTimes(String id, int startTime, int endTime) {
        return new UpdateCuePointsTimesCuePointBuilder(id, startTime, endTime);
    }

    public static UpdateStatusCuePointBuilder updateStatus(String id, CuePointStatus status) {
        return new UpdateStatusCuePointBuilder(id, status);
    }

    public static class UpdateStatusCuePointBuilder
    extends NullRequestBuilder {
        public UpdateStatusCuePointBuilder(String id, CuePointStatus status) {
            super("cuepoint_cuepoint", "updateStatus");
            this.params.add("id", id);
            this.params.add("status", status);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void status(String multirequestToken) {
            this.params.add("status", multirequestToken);
        }
    }

    public static class UpdateCuePointsTimesCuePointBuilder
    extends RequestBuilder<CuePoint, CuePoint.Tokenizer, UpdateCuePointsTimesCuePointBuilder> {
        public UpdateCuePointsTimesCuePointBuilder(String id, int startTime, int endTime) {
            super(CuePoint.class, "cuepoint_cuepoint", "updateCuePointsTimes");
            this.params.add("id", id);
            this.params.add("startTime", startTime);
            this.params.add("endTime", endTime);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void startTime(String multirequestToken) {
            this.params.add("startTime", multirequestToken);
        }

        public void endTime(String multirequestToken) {
            this.params.add("endTime", multirequestToken);
        }
    }

    public static class UpdateCuePointBuilder
    extends RequestBuilder<CuePoint, CuePoint.Tokenizer, UpdateCuePointBuilder> {
        public UpdateCuePointBuilder(String id, CuePoint cuePoint) {
            super(CuePoint.class, "cuepoint_cuepoint", "update");
            this.params.add("id", id);
            this.params.add("cuePoint", cuePoint);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class ServeBulkCuePointBuilder
    extends ServeRequestBuilder {
        public ServeBulkCuePointBuilder(CuePointFilter filter, FilterPager pager) {
            super("cuepoint_cuepoint", "serveBulk");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class ListCuePointBuilder
    extends ListResponseRequestBuilder<CuePoint, CuePoint.Tokenizer, ListCuePointBuilder> {
        public ListCuePointBuilder(CuePointFilter filter, FilterPager pager) {
            super(CuePoint.class, "cuepoint_cuepoint", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetCuePointBuilder
    extends RequestBuilder<CuePoint, CuePoint.Tokenizer, GetCuePointBuilder> {
        public GetCuePointBuilder(String id) {
            super(CuePoint.class, "cuepoint_cuepoint", "get");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class DeleteCuePointBuilder
    extends NullRequestBuilder {
        public DeleteCuePointBuilder(String id) {
            super("cuepoint_cuepoint", "delete");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class CountCuePointBuilder
    extends RequestBuilder<Integer, String, CountCuePointBuilder> {
        public CountCuePointBuilder(CuePointFilter filter) {
            super(Integer.class, "cuepoint_cuepoint", "count");
            this.params.add("filter", filter);
        }
    }

    public static class CloneCuePointBuilder
    extends RequestBuilder<CuePoint, CuePoint.Tokenizer, CloneCuePointBuilder> {
        public CloneCuePointBuilder(String id, String entryId) {
            super(CuePoint.class, "cuepoint_cuepoint", "clone");
            this.params.add("id", id);
            this.params.add("entryId", entryId);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class AddFromBulkCuePointBuilder
    extends ListResponseRequestBuilder<CuePoint, CuePoint.Tokenizer, AddFromBulkCuePointBuilder> {
        public AddFromBulkCuePointBuilder(FileHolder fileData) {
            super(CuePoint.class, "cuepoint_cuepoint", "addFromBulk");
            this.files = new Files();
            this.files.add("fileData", fileData);
        }
    }

    public static class AddCuePointBuilder
    extends RequestBuilder<CuePoint, CuePoint.Tokenizer, AddCuePointBuilder> {
        public AddCuePointBuilder(CuePoint cuePoint) {
            super(CuePoint.class, "cuepoint_cuepoint", "add");
            this.params.add("cuePoint", cuePoint);
        }
    }
}

