/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.AdminUser;
import com.kaltura.client.types.Authentication;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class AdminUserService {
    public static LoginAdminUserBuilder login(String email, String password) {
        return AdminUserService.login(email, password, Integer.MIN_VALUE);
    }

    public static LoginAdminUserBuilder login(String email, String password, int partnerId) {
        return new LoginAdminUserBuilder(email, password, partnerId);
    }

    public static ResetPasswordAdminUserBuilder resetPassword(String email) {
        return new ResetPasswordAdminUserBuilder(email);
    }

    public static SetInitialPasswordAdminUserBuilder setInitialPassword(String hashKey, String newPassword) {
        return new SetInitialPasswordAdminUserBuilder(hashKey, newPassword);
    }

    public static UpdatePasswordAdminUserBuilder updatePassword(String email, String password) {
        return AdminUserService.updatePassword(email, password, "");
    }

    public static UpdatePasswordAdminUserBuilder updatePassword(String email, String password, String newEmail) {
        return AdminUserService.updatePassword(email, password, newEmail, "");
    }

    public static UpdatePasswordAdminUserBuilder updatePassword(String email, String password, String newEmail, String newPassword) {
        return AdminUserService.updatePassword(email, password, newEmail, newPassword, null);
    }

    public static UpdatePasswordAdminUserBuilder updatePassword(String email, String password, String newEmail, String newPassword, String otp) {
        return new UpdatePasswordAdminUserBuilder(email, password, newEmail, newPassword, otp);
    }

    public static class UpdatePasswordAdminUserBuilder
    extends RequestBuilder<AdminUser, AdminUser.Tokenizer, UpdatePasswordAdminUserBuilder> {
        public UpdatePasswordAdminUserBuilder(String email, String password, String newEmail, String newPassword, String otp) {
            super(AdminUser.class, "adminuser", "updatePassword");
            this.params.add("email", email);
            this.params.add("password", password);
            this.params.add("newEmail", newEmail);
            this.params.add("newPassword", newPassword);
            this.params.add("otp", otp);
        }

        public void email(String multirequestToken) {
            this.params.add("email", multirequestToken);
        }

        public void password(String multirequestToken) {
            this.params.add("password", multirequestToken);
        }

        public void newEmail(String multirequestToken) {
            this.params.add("newEmail", multirequestToken);
        }

        public void newPassword(String multirequestToken) {
            this.params.add("newPassword", multirequestToken);
        }

        public void otp(String multirequestToken) {
            this.params.add("otp", multirequestToken);
        }
    }

    public static class SetInitialPasswordAdminUserBuilder
    extends RequestBuilder<Authentication, Authentication.Tokenizer, SetInitialPasswordAdminUserBuilder> {
        public SetInitialPasswordAdminUserBuilder(String hashKey, String newPassword) {
            super(Authentication.class, "adminuser", "setInitialPassword");
            this.params.add("hashKey", hashKey);
            this.params.add("newPassword", newPassword);
        }

        public void hashKey(String multirequestToken) {
            this.params.add("hashKey", multirequestToken);
        }

        public void newPassword(String multirequestToken) {
            this.params.add("newPassword", multirequestToken);
        }
    }

    public static class ResetPasswordAdminUserBuilder
    extends NullRequestBuilder {
        public ResetPasswordAdminUserBuilder(String email) {
            super("adminuser", "resetPassword");
            this.params.add("email", email);
        }

        public void email(String multirequestToken) {
            this.params.add("email", multirequestToken);
        }
    }

    public static class LoginAdminUserBuilder
    extends RequestBuilder<String, String, LoginAdminUserBuilder> {
        public LoginAdminUserBuilder(String email, String password, int partnerId) {
            super(String.class, "adminuser", "login");
            this.params.add("email", email);
            this.params.add("password", password);
            this.params.add("partnerId", partnerId);
        }

        public void email(String multirequestToken) {
            this.params.add("email", multirequestToken);
        }

        public void password(String multirequestToken) {
            this.params.add("password", multirequestToken);
        }

        public void partnerId(String multirequestToken) {
            this.params.add("partnerId", multirequestToken);
        }
    }
}

