/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class FileHolder
implements Serializable {
    private String name;
    private long size;
    private File file;
    private InputStream inputStream;
    private String mimeType;

    public FileHolder(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file must be set");
        }
        if (!file.canRead() || !file.isFile()) {
            throw new IllegalArgumentException("file (" + file.getAbsolutePath() + ") is not readable or not a file");
        }
        this.file = file;
        this.name = this.file.getName();
        this.size = this.file.length();
        try {
            this.mimeType = this.file.toURI().toURL().openConnection().getContentType();
        }
        catch (IOException e) {
            this.mimeType = "application/octet-stream";
        }
    }

    public FileHolder(FileInputStream fileInputStream, String mimeType, String name) {
        if (fileInputStream == null) {
            throw new IllegalArgumentException("fileInputStream must be set");
        }
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("name must be set");
        }
        this.inputStream = fileInputStream;
        this.name = name;
        this.mimeType = mimeType;
        try {
            this.size = fileInputStream.getChannel().size();
        }
        catch (IOException e) {
            throw new RuntimeException("Failure trying to read info from inptustream: " + e, e);
        }
    }

    public FileHolder(InputStream inputStream, String mimeType, String name, long size) {
        if (inputStream == null) {
            throw new IllegalArgumentException("fileInputStream must be set");
        }
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("name must be set");
        }
        if (size <= 0L) {
            throw new IllegalArgumentException("size must be set");
        }
        this.inputStream = inputStream;
        this.name = name;
        this.mimeType = mimeType;
        this.size = size;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public long getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream getInputStream() {
        InputStream fis = this.inputStream;
        if (this.inputStream == null && this.file != null) {
            try {
                fis = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("file (" + this.file.getAbsolutePath() + ") is not readable or not a file");
            }
        }
        return fis;
    }
}

