/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.ILogger;
import com.kaltura.client.Logger;
import com.kaltura.client.LoggerNull;
import com.kaltura.client.RequestQueue;
import com.kaltura.client.utils.ErrorElement;
import com.kaltura.client.utils.request.ConnectionConfiguration;
import com.kaltura.client.utils.request.ExecutedRequest;
import com.kaltura.client.utils.request.RequestElement;
import com.kaltura.client.utils.response.base.Response;
import com.kaltura.client.utils.response.base.ResponseElement;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class APIOkRequestsExecutor
implements RequestQueue {
    public static final String TAG = "APIOkRequestsExecutor";
    static final MediaType JSON_MediaType = MediaType.parse((String)"application/json");
    private ConnectionConfiguration defaultConfiguration = new ConnectionConfiguration(){

        @Override
        public int getReadTimeout() {
            return 20000;
        }

        @Override
        public int getWriteTimeout() {
            return 20000;
        }

        @Override
        public int getConnectTimeout() {
            return 10000;
        }

        @Override
        public boolean getAcceptGzipEncoding() {
            return false;
        }

        @Override
        public int getMaxRetry(int defaultVal) {
            return defaultVal;
        }

        @Override
        public String getEndpoint() {
            return "https://www.kaltura.com";
        }

        @Override
        public String getProxy() {
            return null;
        }

        @Override
        public int getProxyPort() {
            return 0;
        }

        @Override
        public boolean getIgnoreSslDomainVerification() {
            return false;
        }
    };
    private IdFactory idFactory = new IdFactory(){

        @Override
        public String factorId(String factor) {
            return UUID.randomUUID().toString() + "::" + (factor != null ? factor : Long.valueOf(System.currentTimeMillis()));
        }
    };
    private OkHttpClient mOkClient;
    private boolean enableLogs = true;
    private Set<String> enableLogHeaders = new HashSet<String>();
    protected static ILogger logger = Logger.getLogger("APIOkRequestsExecutor");
    protected static APIOkRequestsExecutor self;
    protected static HostnameVerifier hostnameVerifier;
    protected static final TrustManager[] trustAllCerts;
    protected static final SSLContext trustAllSslContext;
    protected static final SSLSocketFactory trustAllSslSocketFactory;

    public static APIOkRequestsExecutor getExecutor() {
        if (self == null) {
            self = new APIOkRequestsExecutor();
        }
        return self;
    }

    public APIOkRequestsExecutor() {
        this.mOkClient = this.configClient(this.createOkClientBuilder(), this.defaultConfiguration).build();
    }

    public APIOkRequestsExecutor(ConnectionConfiguration defaultConfiguration) {
        this.setDefaultConfiguration(defaultConfiguration);
    }

    public APIOkRequestsExecutor setRequestIdFactory(IdFactory factory) {
        this.idFactory = factory;
        return this;
    }

    private OkHttpClient getOkClient(ConnectionConfiguration configuration) {
        if (configuration != null) {
            return this.configClient(this.mOkClient.newBuilder(), configuration).build();
        }
        return this.mOkClient;
    }

    private OkHttpClient.Builder createOkClientBuilder() {
        return new OkHttpClient.Builder().connectionPool(new ConnectionPool());
    }

    private OkHttpClient.Builder configClient(OkHttpClient.Builder builder, ConnectionConfiguration config) {
        builder.followRedirects(true).connectTimeout((long)config.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)config.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)config.getWriteTimeout(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(config.getMaxRetry(1) > 0);
        if (config.getIgnoreSslDomainVerification()) {
            builder.hostnameVerifier(hostnameVerifier);
            builder.sslSocketFactory(trustAllSslSocketFactory, (X509TrustManager)trustAllCerts[0]);
        }
        if (config.getProxy() != null && config.getProxyPort() != 0) {
            logger.debug("Proxy host is: " + config.getProxy());
            logger.debug("Proxy port is: " + config.getProxyPort());
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.getProxy(), config.getProxyPort())));
        } else if (System.getProperty("http_proxy") != null && System.getProperty("http_proxy_port") != null) {
            int proxy_port = 0;
            String proxy_host = System.getProperty("http_proxy");
            String proxy_error = "`http_proxy_port` Java property is set but its value is invalid, will be ignored.";
            try {
                proxy_port = Integer.parseInt(System.getProperty("http_proxy_port"));
            }
            catch (NumberFormatException e) {
                logger.debug(proxy_error);
            }
            catch (NullPointerException e) {
                logger.debug(proxy_error);
            }
            if (proxy_port > 0) {
                logger.debug("Proxy host (taken from Java property - http_proxy) is: " + proxy_host);
                logger.debug("Proxy port (taken from Java property - http_proxy_port) is: " + proxy_port);
                builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy_host, proxy_port)));
            }
        } else if (System.getenv("http_proxy") != null && System.getenv("http_proxy_port") != null) {
            int proxy_port = 0;
            String proxy_host = System.getenv("http_proxy");
            String proxy_error = "`http_proxy_port` ENV var is set but its value is invalid, will be ignored.";
            try {
                proxy_port = Integer.parseInt(System.getenv("http_proxy_port"));
            }
            catch (NumberFormatException e) {
                logger.debug(proxy_error);
            }
            catch (NullPointerException e) {
                logger.debug(proxy_error);
            }
            if (proxy_port > 0) {
                logger.debug("Proxy host (taken from ENV var - http_proxy): " + proxy_host);
                logger.debug("Proxy port (taken from ENV var - http_proxy_port): " + proxy_port);
                builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy_host, proxy_port)));
            }
        }
        return builder;
    }

    @Override
    public void setDefaultConfiguration(ConnectionConfiguration defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
        this.mOkClient = this.configClient(this.createOkClientBuilder(), defaultConfiguration).build();
    }

    @Override
    public void enableLogs(boolean enable) {
        this.enableLogs = enable;
        logger = enable ? Logger.getLogger(TAG) : new LoggerNull(TAG);
    }

    @Override
    public void enableLogResponseHeader(String header, boolean log) {
        if (log) {
            if (!this.enableLogHeaders.contains(header)) {
                this.enableLogHeaders.add(header);
            }
        } else if (this.enableLogHeaders.contains(header)) {
            this.enableLogHeaders.remove(header);
        }
    }

    @Override
    public String queue(RequestElement requestElement) {
        Request request = this.buildRestRequest(requestElement);
        return this.queue(request, requestElement);
    }

    private String queue(Request request, final RequestElement action) {
        try {
            Call call = this.getOkClient(action.config()).newCall(request);
            call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    if (call.isCanceled()) {
                        logger.warn("onFailure: call " + call.request().tag() + " was canceled. not passing results");
                        return;
                    }
                    ExecutedRequest responseElement = new ExecutedRequest().error(e).success(false);
                    APIOkRequestsExecutor.this.postCompletion(action, responseElement);
                }

                public void onResponse(Call call, okhttp3.Response response) throws IOException {
                    if (call.isCanceled()) {
                        logger.warn("call " + call.request().tag() + " was canceled. not passing results");
                        return;
                    }
                    APIOkRequestsExecutor.this.postCompletion(action, APIOkRequestsExecutor.this.onGotResponse(response, action));
                }
            });
            return (String)call.request().tag();
        }
        catch (Exception e) {
            e.printStackTrace();
            ExecutedRequest responseElement = new ExecutedRequest().response(this.getErrorResponse(e)).success(false);
            this.postCompletion(action, responseElement);
            return null;
        }
    }

    protected void postCompletion(RequestElement action, ResponseElement responseElement) {
        Response apiResponse = action.parseResponse(responseElement);
        action.onComplete(apiResponse);
    }

    private String getErrorResponse(Exception e) {
        return e.getClass().getName() + ": " + e.getMessage();
    }

    @Override
    public Response<?> execute(RequestElement request) {
        try {
            okhttp3.Response response = this.getOkClient(request.config()).newCall(this.buildRestRequest(request)).execute();
            return request.parseResponse(this.onGotResponse(response, request));
        }
        catch (IOException e) {
            ExecutedRequest responseElement = new ExecutedRequest().response(this.getErrorResponse(e)).success(false);
            return request.parseResponse(responseElement);
        }
    }

    public boolean hasRequest(String reqId) {
        Dispatcher dispatcher = this.getOkClient(null).dispatcher();
        Call call = this.findCall(reqId, dispatcher.queuedCalls());
        if (call != null) {
            return true;
        }
        call = this.findCall(reqId, dispatcher.runningCalls());
        return call != null;
    }

    @Override
    public void cancelRequest(String reqId) {
        Dispatcher dispatcher = this.getOkClient(null).dispatcher();
        Call call = this.findCall(reqId, dispatcher.queuedCalls());
        if (call != null) {
            call.cancel();
        }
        if ((call = this.findCall(reqId, dispatcher.runningCalls())) != null) {
            call.cancel();
        }
    }

    private Call findCall(String reqId, List<Call> calls) {
        for (Call call : calls) {
            if (!call.request().tag().equals(reqId)) continue;
            return call;
        }
        return null;
    }

    @Override
    public void clearRequests() {
        if (this.mOkClient != null) {
            this.mOkClient.dispatcher().cancelAll();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.mOkClient == null || this.mOkClient.dispatcher().queuedCallsCount() == 0;
    }

    protected ResponseElement onGotResponse(okhttp3.Response response, RequestElement action) {
        String requestId = this.getRequestId(response);
        if (this.enableLogHeaders.contains("*")) {
            logger.debug("response [" + requestId + "] Response: " + response.code() + " " + response.message());
            for (String header : response.headers().names()) {
                logger.debug("response [" + requestId + "] " + header + ": " + response.headers().get(header));
            }
        } else {
            for (String header : this.enableLogHeaders) {
                String value = response.headers().get(header);
                if (value == null) continue;
                logger.debug("response [" + requestId + "] " + header + ": " + value);
            }
        }
        if (!response.isSuccessful()) {
            return new ExecutedRequest().requestId(requestId).headers(response.headers().toMultimap()).error(ErrorElement.fromCode(response.code(), response.message())).success(false);
        }
        String responseString = null;
        try {
            responseString = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("failed to retrieve the response body!");
        }
        if (this.enableLogs) {
            logger.debug("response [" + requestId + "] body:\n" + responseString);
        }
        return new ExecutedRequest().requestId(requestId).response(responseString).headers(response.headers().toMultimap()).code(response.code()).success(responseString != null);
    }

    protected String getRequestId(okhttp3.Response response) {
        try {
            return response.request().tag().toString();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    private Request buildRestRequest(RequestElement request) {
        RequestBody body;
        Files files = request.getFiles();
        if (files == null) {
            body = BodyBuilder.Default.build(request);
        } else {
            MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("json", request.getBody());
            for (String fieldName : files.keySet()) {
                FileHolder fileHolder = (FileHolder)files.get(fieldName);
                MediaType mediaType = MediaType.parse((String)fileHolder.getMimeType());
                if (fileHolder.getFile() != null) {
                    bodyBuilder.addFormDataPart(fieldName, fileHolder.getName(), RequestBody.create((MediaType)mediaType, (File)fileHolder.getFile()));
                    continue;
                }
                if (fileHolder.getInputStream() == null) continue;
                bodyBuilder.addFormDataPart(fieldName, fileHolder.getName(), (RequestBody)new InputStreamRequestBody(mediaType, fileHolder.getInputStream()));
            }
            body = bodyBuilder.build();
        }
        String url = request.getUrl();
        String requestId = this.idFactory.factorId(request.getTag());
        if (this.enableLogs) {
            logger.debug("request [" + requestId + "] url: " + url + "\nbody:\n" + request.getBody() + "\n");
        }
        return new Request.Builder().headers(Headers.of(request.getHeaders())).method(request.getMethod(), body).url(url).tag((Object)requestId).build();
    }

    public static String getRequestBody(Request request) {
        try {
            Request copy = request.newBuilder().build();
            Buffer buffer = new Buffer();
            copy.body().writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            return "did not work";
        }
    }

    static {
        hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        };
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            trustAllSslContext = SSLContext.getInstance("SSL");
            trustAllSslContext.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        trustAllSslSocketFactory = trustAllSslContext.getSocketFactory();
    }

    private static interface BodyBuilder {
        public static final BodyBuilder Default = new BodyBuilder(){

            @Override
            public RequestBody build(RequestElement requestElement) {
                return requestElement.getBody() != null ? RequestBody.create((MediaType)JSON_MediaType, (byte[])requestElement.getBody().getBytes()) : null;
            }
        };

        public RequestBody build(RequestElement var1);
    }

    private static class InputStreamRequestBody
    extends RequestBody {
        private InputStream inputStream;
        private MediaType mediaType;

        public InputStreamRequestBody(MediaType mediaType, InputStream inputStream) {
            this.mediaType = mediaType;
            this.inputStream = inputStream;
        }

        public MediaType contentType() {
            return this.mediaType;
        }

        public long contentLength() {
            try {
                return this.inputStream.available();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        public void writeTo(BufferedSink sink) throws IOException {
            Source source = null;
            try {
                source = Okio.source((InputStream)this.inputStream);
                sink.writeAll(source);
            }
            finally {
                Util.closeQuietly((Closeable)source);
            }
        }
    }

    public static interface IdFactory {
        public String factorId(String var1);
    }
}

