/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.kaltura.utils;

import com.kaltura.client.APIOkRequestsExecutor;
import com.kaltura.client.utils.request.RequestElement;
import com.kaltura.client.utils.response.base.Response;
import com.lucidworks.connector.plugins.kaltura.utils.SafeGsonParser;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeRequestExecutor
extends APIOkRequestsExecutor {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(SafeRequestExecutor.class);
    private static final AtomicLong idCounter = new AtomicLong(0L);

    public Response<?> execute(RequestElement request) {
        try {
            return super.execute(request);
        }
        catch (Exception e) {
            if (SafeRequestExecutor.isGsonReflectionError(e)) {
                logger.warn("Gson reflection error detected, handling gracefully: {}", (Object)e.getMessage());
                return new Response(null, SafeGsonParser.parseException("{}"));
            }
            throw e;
        }
    }

    public String queue(RequestElement request) {
        try {
            return super.queue(request);
        }
        catch (Exception e) {
            if (SafeRequestExecutor.isGsonReflectionError(e)) {
                logger.warn("Gson reflection error in queue operation: {}", (Object)e.getMessage());
                request.onComplete(new Response(null, SafeGsonParser.parseException("{}")));
                return "safe_request_" + System.currentTimeMillis() + "_" + idCounter.incrementAndGet();
            }
            throw e;
        }
    }

    public static boolean isGsonReflectionError(Exception e) {
        String message = e.getMessage();
        if (message == null) {
            return false;
        }
        return message.contains("InaccessibleObjectException") || message.contains("Failed making field") || message.contains("detailMessage") && (message.contains("accessible") || message.contains("field") || message.length() < 50) && !message.contains("but not in the right context") || message.contains("java.lang.Throwable") && message.contains("accessible") && !message.contains("without accessible") && !message.contains("accessible without");
    }
}

