/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.kaltura.retrievers;

import com.google.inject.Inject;
import com.kaltura.client.services.CategoryEntryService;
import com.kaltura.client.services.CategoryService;
import com.kaltura.client.services.CategoryUserService;
import com.kaltura.client.services.MediaService;
import com.kaltura.client.services.MetadataService;
import com.kaltura.client.services.UserRoleService;
import com.kaltura.client.services.UserService;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.Category;
import com.kaltura.client.types.CategoryEntry;
import com.kaltura.client.types.CategoryEntryFilter;
import com.kaltura.client.types.CategoryFilter;
import com.kaltura.client.types.CategoryUser;
import com.kaltura.client.types.CategoryUserFilter;
import com.kaltura.client.types.MediaEntry;
import com.kaltura.client.types.MediaEntryFilter;
import com.kaltura.client.types.Metadata;
import com.kaltura.client.types.MetadataFilter;
import com.kaltura.client.types.User;
import com.kaltura.client.types.UserFilter;
import com.kaltura.client.types.UserRole;
import com.kaltura.client.types.UserRoleFilter;
import com.lucidworks.connector.plugins.kaltura.data.DataRetrievalException;
import com.lucidworks.connector.plugins.kaltura.retrievers.ItemRetriever;
import com.lucidworks.connector.plugins.kaltura.retrievers.ListRetriever;
import java.util.List;
import java.util.function.Function;

public class Retrievers {
    private final ListRetriever listRetriever;
    private final ItemRetriever itemRetriever;

    @Inject
    public Retrievers(ListRetriever listRetriever, ItemRetriever itemRetriever) {
        this.listRetriever = listRetriever;
        this.itemRetriever = itemRetriever;
    }

    public <T> List<T> mediaList(MediaEntryFilter filter, Function<MediaEntry, T> map, int limit) throws DataRetrievalException {
        return this.listRetriever.collect(MediaService.list((MediaEntryFilter)filter), map, limit);
    }

    public <T> List<T> userList(UserFilter filter, Function<User, T> map) throws DataRetrievalException {
        return this.listRetriever.collect(UserService.list((UserFilter)filter), map);
    }

    public <T> List<T> userRoleList(UserRoleFilter filter, Function<UserRole, T> map) throws DataRetrievalException {
        return this.listRetriever.collect(UserRoleService.list((UserRoleFilter)filter), map);
    }

    public <T> List<T> categoryUserList(CategoryUserFilter filter, Function<CategoryUser, T> map) throws DataRetrievalException {
        return this.listRetriever.collect(CategoryUserService.list((CategoryUserFilter)filter), map);
    }

    public <T> List<T> categoryEntryList(CategoryEntryFilter filter, Function<CategoryEntry, T> map) throws DataRetrievalException {
        return this.listRetriever.collect(CategoryEntryService.list((CategoryEntryFilter)filter), map);
    }

    public <T> List<T> categoryList(CategoryFilter filter, Function<Category, T> map) throws DataRetrievalException {
        return this.listRetriever.collect(CategoryService.list((CategoryFilter)filter), map);
    }

    public <T> List<T> metadataList(MetadataFilter filter, Function<Metadata, T> map) throws DataRetrievalException {
        return this.listRetriever.collect(MetadataService.list((MetadataFilter)filter), map);
    }

    public MediaEntry mediaEntry(String entryId) throws APIException {
        return (MediaEntry)this.itemRetriever.get(MediaService.get((String)entryId)).results;
    }
}

