/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.kaltura.retrievers;

import com.google.inject.Inject;
import com.kaltura.client.RequestQueue;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.ListResponse;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.response.OnCompletion;
import com.kaltura.client.utils.response.base.Response;
import com.lucidworks.connector.plugins.kaltura.ClientWrapper;
import com.lucidworks.connector.plugins.kaltura.config.ConfigWrapper;
import com.lucidworks.connector.plugins.kaltura.data.DataRetrievalException;
import com.lucidworks.connector.plugins.kaltura.utils.SafeRequestExecutor;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListRetriever {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(ListRetriever.class);
    private final ClientWrapper client;
    private final RequestQueue executor;
    private int pageSize = 10;

    @Inject
    public ListRetriever(RequestQueue executor, ClientWrapper kalturaClient, ConfigWrapper config) {
        this.executor = executor;
        this.client = kalturaClient;
        this.pageSize = config.getPageSize();
    }

    private <R, T, B> void processPage(FilterPager pager, CountDownLatch latch, OnCompletion<Response<ListResponse<R>>> completion, ListResponseRequestBuilder<R, T, B> builder, List<Exception> exceptions) {
        builder.setParams(ListRetriever.paramsWithPager(pager));
        builder.setCompletion(result -> {
            try {
                if (result.error != null) {
                    exceptions.add((Exception)result.error);
                } else {
                    completion.onComplete(result);
                }
            }
            catch (Exception e) {
                if (SafeRequestExecutor.isGsonReflectionError(e)) {
                    logger.warn("Gson reflection error detected in processPage, using safe executor");
                    try {
                        SafeRequestExecutor safeExecutor = new SafeRequestExecutor();
                        Response<?> safeResponse = safeExecutor.execute(builder.build(this.client.get()));
                        if (safeResponse != null && safeResponse.error != null) {
                            exceptions.add((Exception)safeResponse.error);
                        } else if (safeResponse != null) {
                            completion.onComplete(safeResponse);
                        }
                    }
                    catch (Exception safeEx) {
                        exceptions.add(safeEx);
                    }
                }
                exceptions.add(e);
            }
            latch.countDown();
        });
        try {
            this.executor.queue(builder.build(this.client.get()));
        }
        catch (Exception e) {
            if (SafeRequestExecutor.isGsonReflectionError(e)) {
                logger.warn("Gson reflection error detected in queue, using safe executor");
                try {
                    SafeRequestExecutor safeExecutor = new SafeRequestExecutor();
                    safeExecutor.queue(builder.build(this.client.get()));
                }
                catch (Exception safeEx) {
                    exceptions.add(safeEx);
                    latch.countDown();
                }
            }
            exceptions.add(e);
            latch.countDown();
        }
    }

    private <R, T, B> int processFirstPage(FilterPager pager, OnCompletion<Response<ListResponse<R>>> completion, ListResponseRequestBuilder<R, T, B> builder) throws DataRetrievalException {
        builder.setParams(ListRetriever.paramsWithPager(pager));
        try {
            Response response = this.executor.execute(builder.build(this.client.get()));
            if (response.error != null) {
                throw response.error;
            }
            completion.onComplete((Object)response);
            return ((ListResponse)response.results).getTotalCount();
        }
        catch (Exception e) {
            if (SafeRequestExecutor.isGsonReflectionError(e)) {
                logger.warn("Gson reflection error detected in processFirstPage, using safe executor");
                try {
                    SafeRequestExecutor safeExecutor = new SafeRequestExecutor();
                    Response<?> response = safeExecutor.execute(builder.build(this.client.get()));
                    if (response != null && response.error != null) {
                        throw response.error;
                    }
                    if (response != null) {
                        completion.onComplete(response);
                        return ((ListResponse)response.results).getTotalCount();
                    }
                }
                catch (Exception safeEx) {
                    throw new DataRetrievalException("Exception during safe list retrieval", safeEx);
                }
            }
            throw new DataRetrievalException("Exception during list retrieval", e);
        }
    }

    @NotNull
    private static Map<String, Object> paramsWithPager(FilterPager pager) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pager", pager.toParams());
        return params;
    }

    public <R, T, B> int traverse(OnCompletion<Response<ListResponse<R>>> completion, ListResponseRequestBuilder<R, T, B> builder, int limit) throws DataRetrievalException {
        int pageCount;
        List<Exception> exceptions = Collections.synchronizedList(new LinkedList());
        FilterPager pager = new FilterPager();
        pager.setPageSize(Integer.valueOf(this.pageSize));
        pager.setPageIndex(Integer.valueOf(1));
        int totalCount = this.processFirstPage(pager, completion, builder);
        if (limit > -1) {
            totalCount = Math.min(limit, totalCount);
        }
        if ((pageCount = (totalCount + this.pageSize - 1) / this.pageSize) > 1) {
            CountDownLatch doneSignal = new CountDownLatch(pageCount - 1);
            for (int i = 2; i <= pageCount; ++i) {
                if (limit > -1 && i * this.pageSize > limit) {
                    pager.setPageSize(Integer.valueOf(limit - this.pageSize * (i - 1)));
                }
                pager.setPageIndex(Integer.valueOf(i));
                this.processPage(pager, doneSignal, completion, builder, exceptions);
            }
            try {
                doneSignal.await();
            }
            catch (InterruptedException e) {
                throw new DataRetrievalException("Error while retrieving data", e);
            }
        }
        this.processExceptions(exceptions);
        return totalCount;
    }

    private void processExceptions(List<Exception> exceptions) throws DataRetrievalException {
        boolean isError = !exceptions.isEmpty();
        for (Exception e : exceptions) {
            logger.error("Exception during list retrieval.", (Throwable)e);
        }
        if (isError) {
            throw new DataRetrievalException("Exceptions during list retrieval");
        }
    }

    public <R, T, B, O> List<O> collect(ListResponseRequestBuilder<R, T, B> builder, Function<R, O> map) throws DataRetrievalException {
        return this.collect(builder, map, -1);
    }

    public <R, T, B, O> List<O> collect(ListResponseRequestBuilder<R, T, B> builder, Function<R, O> map, int limit) throws DataRetrievalException {
        List output = Collections.synchronizedList(new LinkedList());
        int totalCount = this.traverse(r -> ((ListResponse)r.results).getObjects().stream().map(map).forEach(output::add), builder, limit);
        this.validateOutput(output, totalCount);
        return output;
    }

    private <O> void validateOutput(List<O> output, int totalCount) throws DataRetrievalException {
        if (totalCount != output.size()) {
            throw new DataRetrievalException("Data inconsistency error, totalCount: " + totalCount + " but retrieved: " + output.size());
        }
    }
}

