/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.kaltura.retrievers;

import com.google.inject.Inject;
import com.kaltura.client.RequestQueue;
import com.kaltura.client.types.APIException;
import com.kaltura.client.utils.request.BaseRequestBuilder;
import com.kaltura.client.utils.response.base.Response;
import com.lucidworks.connector.plugins.kaltura.ClientWrapper;
import com.lucidworks.connector.plugins.kaltura.utils.SafeRequestExecutor;

public class ItemRetriever {
    RequestQueue executor;
    ClientWrapper client;

    @Inject
    public ItemRetriever(RequestQueue executor, ClientWrapper client) {
        this.executor = executor;
        this.client = client;
    }

    public <T, B> Response<T> get(BaseRequestBuilder<T, B> builder) throws APIException {
        try {
            Response resp = this.executor.execute(builder.build(this.client.get()));
            if (resp != null && resp.error != null) {
                throw resp.error;
            }
            return resp;
        }
        catch (APIException e) {
            throw e;
        }
        catch (Exception e) {
            if (SafeRequestExecutor.isGsonReflectionError(e)) {
                SafeRequestExecutor safeExecutor = new SafeRequestExecutor();
                Response<?> resp = safeExecutor.execute(builder.build(this.client.get()));
                if (resp != null && resp.error != null) {
                    throw resp.error;
                }
                return resp;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to execute request", e);
        }
    }
}

