/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.kaltura.processors;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.lucidworks.connector.plugins.kaltura.data.DataRetrievalException;
import com.lucidworks.connector.plugins.kaltura.data.MediaDataCollector;
import com.lucidworks.connector.plugins.kaltura.data.entity.Data;
import com.lucidworks.connector.plugins.kaltura.data.entity.DataFiltered;
import com.lucidworks.connector.plugins.kaltura.data.entity.DataNotFound;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.builders.GraphAccessControlBuilder;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Candidate;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.ContentFetcher;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Document;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KalturaProcessor {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(KalturaProcessor.class);
    private final MediaDataCollector dataCollector;

    @Inject
    public KalturaProcessor(MediaDataCollector dataCollector) {
        this.dataCollector = dataCollector;
    }

    public void findCandidates(ContentFetcher.FetchContext context) throws DataRetrievalException {
        boolean fromConfig = !context.getFetchInput().hasId();
        this.dataCollector.processIds(id -> {
            logger.info("Emitting candidate id: {} from root={}", id, (Object)fromConfig);
            ((Candidate.Emitter)context.newCandidate(id).metadata(m -> m.setBoolean("from-root", Boolean.valueOf(fromConfig)))).emit();
        });
    }

    public void processItem(ContentFetcher.FetchContext context) throws DataRetrievalException {
        String digestExisting;
        String id = context.getFetchInput().getId();
        Data kalturaData = this.dataCollector.getData(id);
        if (kalturaData instanceof DataNotFound) {
            logger.debug("Deleting id: {} due to data not found", (Object)id);
            context.newDelete(id).emit();
            return;
        }
        if (kalturaData instanceof DataFiltered) {
            logger.debug("Deleting id: {} due to filtering", (Object)id);
            context.newDelete(id).emit();
            return;
        }
        Map meta = context.getFetchInput().getMetadata();
        String digestFetched = kalturaData.getDigest();
        if (!(meta == null || (digestExisting = (String)meta.get("digest")) != null && digestExisting.equals(digestFetched))) {
            logger.debug("Emitting id: {}", (Object)id);
            this.emitNew(context, kalturaData, digestFetched);
            return;
        }
        logger.debug("Skipping id: {}", (Object)id);
    }

    @VisibleForTesting
    public void emitNew(ContentFetcher.FetchContext context, Data data, String digest) {
        String id = context.getFetchInput().getId();
        HashMap<String, Object> additionalFields = new HashMap<String, Object>(data.getFields());
        additionalFields.put("_lw_document_type_s", "contentDocument");
        Document.Emitter emitter = (Document.Emitter)((Document.Emitter)context.newDocument(id).fields(f -> f.merge(additionalFields))).metadata(f -> f.setString("digest", digest));
        if (data.getAcls() != null) {
            emitter.withACLs(data.getAcls());
        }
        emitter.emit();
        HashMap<String, String> additionalAclFields = new HashMap<String, String>();
        additionalAclFields.put("type_s", "kaltura-user");
        additionalAclFields.put("_lw_document_type_s", "aclDocument");
        if (data.getAcls() != null) {
            ((Stream)Arrays.stream(data.getAcls()).sequential()).forEach(u -> {
                additionalAclFields.put("userId_s", (String)u);
                ((GraphAccessControlBuilder.Emitter)context.newGraphAccessControl(u).fields(f -> f.merge(additionalAclFields))).emit();
            });
        }
    }
}

