/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.kaltura.fetcher;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.kaltura.data.DataRetrievalException;
import com.lucidworks.connector.plugins.kaltura.fetcher.FetcherException;
import com.lucidworks.connector.plugins.kaltura.processors.KalturaProcessor;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.FetchResult;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.StartResult;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.StopResult;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Candidate;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.ContentFetcher;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.FetchInput;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KalturaFetcher
implements ContentFetcher {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(KalturaFetcher.class);
    public static final String FETCH_INITIAL_CANDIDATES = "fetch-initial-candidates";
    private KalturaProcessor mediaProcessor;

    @Inject
    public KalturaFetcher(KalturaProcessor mediaProcessor) {
        this.mediaProcessor = mediaProcessor;
    }

    public StartResult start(ContentFetcher.StartContext context) {
        logger.info("Starting fetcher context={}", (Object)context);
        return context.newResult();
    }

    public static DocumentBuilder getXmlParser(DocumentBuilderFactory factory) {
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new FetcherException("Unable to initialize XML parser", e);
        }
    }

    public StopResult stop(ContentFetcher.StopContext context) {
        logger.info("Stopping fetcher context={}", (Object)context);
        return context.newResult();
    }

    public FetchResult fetch(ContentFetcher.FetchContext context) {
        Object message;
        FetchInput input = context.getFetchInput();
        if (!input.hasId()) {
            ((Candidate.Emitter)context.newCandidate(FETCH_INITIAL_CANDIDATES).metadata(m -> m.setBoolean(FETCH_INITIAL_CANDIDATES, Boolean.TRUE))).emit();
            return context.newResult();
        }
        String id = context.getFetchInput().getId();
        logger.info("Processing id: {}", (Object)id);
        Map metadata = context.getFetchInput().getMetadata();
        try {
            if (metadata != null && metadata.get(FETCH_INITIAL_CANDIDATES) != null) {
                logger.info("fetching new candidates");
                this.processCandidates(context);
                return context.newResult();
            }
        }
        catch (DataRetrievalException e) {
            message = "Error while discovering new items.";
            logger.error((String)message, (Throwable)e);
            context.newError(id, (String)message).emit();
        }
        try {
            this.processItem(context);
        }
        catch (DataRetrievalException e) {
            message = "Error while processing id: " + id;
            logger.error((String)message, (Throwable)e);
            context.newError(id, (String)message).emit();
        }
        return context.newResult();
    }

    private void processItem(ContentFetcher.FetchContext context) throws DataRetrievalException {
        this.mediaProcessor.processItem(context);
    }

    private void processCandidates(ContentFetcher.FetchContext context) throws DataRetrievalException {
        this.mediaProcessor.findCandidates(context);
    }
}

