/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.kaltura.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.BaseUser;
import com.kaltura.client.types.Category;
import com.kaltura.client.types.CategoryEntry;
import com.kaltura.client.types.CategoryEntryFilter;
import com.kaltura.client.types.CategoryFilter;
import com.kaltura.client.types.CategoryUser;
import com.kaltura.client.types.CategoryUserFilter;
import com.kaltura.client.types.MediaEntry;
import com.kaltura.client.types.MediaEntryFilter;
import com.kaltura.client.types.Metadata;
import com.kaltura.client.types.MetadataFilter;
import com.kaltura.client.types.UserFilter;
import com.kaltura.client.types.UserRole;
import com.kaltura.client.types.UserRoleFilter;
import com.lucidworks.connector.plugins.kaltura.config.ConfigWrapper;
import com.lucidworks.connector.plugins.kaltura.data.DataRetrievalException;
import com.lucidworks.connector.plugins.kaltura.data.entity.Data;
import com.lucidworks.connector.plugins.kaltura.data.entity.DataFiltered;
import com.lucidworks.connector.plugins.kaltura.data.entity.DataFound;
import com.lucidworks.connector.plugins.kaltura.data.entity.DataNotFound;
import com.lucidworks.connector.plugins.kaltura.retrievers.Retrievers;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MediaDataCollector {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(MediaDataCollector.class);
    public static final int API_LIMIT = 10000;
    private static final String PUBLISHER_ADMINS_ROLE = "Publisher Administrator";
    private static final String ENTRY_ID_NOT_FOUND = "ENTRY_ID_NOT_FOUND";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Retrievers retrievers;
    private final String filteredName;
    private final List<String> excludedIds;
    private final DocumentBuilder xmlParser;
    private Set<String> publisherAdmins;

    @Inject
    public MediaDataCollector(Retrievers retrievers, ConfigWrapper config, DocumentBuilder xmlParser) {
        this.retrievers = retrievers;
        this.filteredName = config.getFilteredName();
        this.excludedIds = config.getExcludedIds();
        this.xmlParser = xmlParser;
    }

    public Data getData(String mediaEntryId) throws DataRetrievalException {
        MediaEntry entry;
        if (this.excludedIds != null && this.excludedIds.contains(mediaEntryId)) {
            return new DataFiltered();
        }
        try {
            entry = this.retrievers.mediaEntry(mediaEntryId);
        }
        catch (APIException e) {
            if (ENTRY_ID_NOT_FOUND.equals(e.getCode())) {
                return new DataNotFound();
            }
            throw new DataRetrievalException("Error while fetching MediaEntry object.", e);
        }
        if (this.filteredName != null && !entry.getName().contains(this.filteredName)) {
            return new DataFiltered();
        }
        String categoryIds = this.getCategoryIds(mediaEntryId);
        Map<String, Object> fields = this.getFields(entry, this.getCategories(categoryIds), this.getMetadata(entry.getId()));
        String[] acls = this.getAcls(categoryIds, mediaEntryId);
        return new DataFound(fields, acls);
    }

    private Map<String, String> getMetadata(String id) throws DataRetrievalException {
        MetadataFilter filter = new MetadataFilter();
        filter.setObjectIdEqual(id);
        List<String> metadataList = this.retrievers.metadataList(filter, Metadata::getXml);
        if (metadataList.isEmpty() || StringUtils.isBlank((String)metadataList.get(0))) {
            return Map.of();
        }
        try {
            return this.parseMetadataXml(metadataList.get(0));
        }
        catch (IOException | SAXException e) {
            throw new DataRetrievalException("Cannot parse metadata of media id: " + id, e);
        }
    }

    private Map<String, String> parseMetadataXml(String xml) throws IOException, SAXException {
        HashMap<String, String> fields = new HashMap<String, String>();
        Document document = this.xmlParser.parse(new InputSource(new StringReader(xml)));
        NodeList metadata = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < metadata.getLength(); ++i) {
            Node element = metadata.item(i);
            fields.put(element.getNodeName(), element.getTextContent());
        }
        return fields;
    }

    private List<Category> getCategories(String categoryIds) throws DataRetrievalException {
        if (StringUtils.isBlank((String)categoryIds)) {
            return new ArrayList<Category>();
        }
        CategoryFilter filter = new CategoryFilter();
        filter.setIdIn(categoryIds);
        return this.retrievers.categoryList(filter, c -> c);
    }

    public void processIds(Consumer<String> consumer) throws DataRetrievalException {
        boolean hasMore;
        MediaEntryFilter filter = new MediaEntryFilter();
        if (this.excludedIds != null) {
            filter.setIdNotIn(String.join((CharSequence)",", this.excludedIds));
        }
        filter.setNameLike(this.filteredName);
        filter.orderBy("createdAt");
        do {
            ArrayList<MediaData> mediaList = new ArrayList<MediaData>(this.retrievers.mediaList(filter, e -> new MediaData(e.getId(), e.getCreatedAt()), 10000));
            OptionalLong lastCreatedAt = mediaList.stream().mapToLong(m -> m.createdAt).max();
            mediaList.stream().map(m -> m.id).forEach(consumer);
            if (mediaList.size() == 10000) {
                filter.setCreatedAtGreaterThanOrEqual(Long.valueOf(lastCreatedAt.getAsLong()));
                hasMore = true;
                continue;
            }
            hasMore = false;
        } while (hasMore);
    }

    private String[] getAcls(String categoryIds, String mediaEntryId) throws DataRetrievalException {
        HashSet<String> acls = new HashSet<String>(this.retrieveCategoryUsers(categoryIds));
        acls.addAll(this.retrieveEntryUsers(mediaEntryId));
        if (this.publisherAdmins == null) {
            Integer roleId = this.retrieveRoleId(PUBLISHER_ADMINS_ROLE);
            this.publisherAdmins = this.retrieveUsersOfRoleId(roleId);
        }
        acls.addAll(this.publisherAdmins);
        return acls.toArray(new String[0]);
    }

    private Map<String, Object> getFields(MediaEntry me, List<Category> categories, Map<String, String> metadata) {
        Map fields = (Map)objectMapper.convertValue((Object)me, (TypeReference)new TypeReference<Map<String, Object>>(){});
        this.removeRelatedObjects(fields);
        for (Map.Entry entry : fields.entrySet()) {
            try {
                fields.put((String)entry.getKey(), this.convertNestedObjects(entry.getValue()));
            }
            catch (JsonProcessingException e) {
                fields.put((String)entry.getKey(), String.format("ERROR: %s", e.getMessage()));
                logger.error(String.format("Could not add field %s:%s", entry.getKey(), entry.getValue()), (Throwable)e);
            }
        }
        categories = categories.stream().sorted(Comparator.comparingInt(Category::getId)).collect(Collectors.toList());
        fields.put("category_id", categories.stream().map(Category::getId).collect(Collectors.toList()));
        fields.put("category_name", categories.stream().map(Category::getName).collect(Collectors.toList()));
        fields.put("category_fullName", categories.stream().map(Category::getFullName).collect(Collectors.toList()));
        fields.put("category_owner", categories.stream().map(Category::getOwner).collect(Collectors.toList()));
        metadata.forEach((k, v) -> fields.put("metadata_" + k, v));
        return fields;
    }

    private Object convertNestedObjects(Object field) throws JsonProcessingException {
        if (field instanceof Map) {
            return objectMapper.writeValueAsString(field);
        }
        if (field instanceof List) {
            ArrayList<String> outputList = new ArrayList<String>();
            for (Object element : (List)field) {
                outputList.add(objectMapper.writeValueAsString(element));
            }
            return outputList;
        }
        return field;
    }

    private void removeRelatedObjects(Object field) {
        if (field instanceof Map) {
            Map mapField = (Map)field;
            mapField.remove("relatedObjects");
            mapField.values().forEach(this::removeRelatedObjects);
        }
        if (field instanceof List) {
            ((List)field).forEach(this::removeRelatedObjects);
        }
    }

    private Integer retrieveRoleId(String roleName) throws DataRetrievalException {
        List<Integer> ids;
        UserRoleFilter filter = new UserRoleFilter();
        filter.setNameEqual(roleName);
        try {
            ids = this.retrievers.userRoleList(filter, UserRole::getId);
        }
        catch (Exception ex) {
            throw new DataRetrievalException("Please ensure the account you are trying to index with has the the `View Only` setting under the `Account Settings` permission list. No further permissions are needed for indexing.");
        }
        if (ids.isEmpty()) {
            throw new DataRetrievalException("Found no role id for role name '" + roleName + "'");
        }
        return ids.get(0);
    }

    private Set<String> retrieveUsersOfRoleId(Integer roleId) throws DataRetrievalException {
        UserFilter filter = new UserFilter();
        filter.setRoleIdsEqual(roleId.toString());
        return this.retrievers.userList(filter, BaseUser::getId).stream().collect(Collectors.toSet());
    }

    private String getCategoryIds(String entryId) throws DataRetrievalException {
        CategoryEntryFilter filter = new CategoryEntryFilter();
        filter.setEntryIdEqual(entryId);
        return this.retrievers.categoryEntryList(filter, CategoryEntry::getCategoryId).stream().map(Object::toString).collect(Collectors.joining(","));
    }

    private List<String> retrieveCategoryUsers(String categoryIds) throws DataRetrievalException {
        if (StringUtils.isBlank((String)categoryIds)) {
            return new LinkedList<String>();
        }
        CategoryUserFilter filter = new CategoryUserFilter();
        filter.setCategoryIdIn(categoryIds);
        return this.retrievers.categoryUserList(filter, CategoryUser::getUserId);
    }

    private Set<String> retrieveEntryUsers(String mediaEntryId) throws DataRetrievalException {
        MediaEntry entry;
        try {
            entry = this.retrievers.mediaEntry(mediaEntryId);
        }
        catch (APIException e) {
            throw new DataRetrievalException("Error while fetching MediaEntry object.", e);
        }
        HashSet<String> entryUsers = new HashSet<String>();
        Stream.of(entry.getEntitledUsersEdit(), entry.getEntitledUsersPublish(), entry.getEntitledUsersView()).filter(Objects::nonNull).filter(s -> !s.trim().isEmpty()).flatMap(s -> Arrays.stream(s.split(","))).forEach(entryUsers::add);
        return entryUsers;
    }

    private static class MediaData {
        private final String id;
        private final long createdAt;

        public MediaData(String id, long createdAt) {
            this.id = id;
            this.createdAt = createdAt;
        }
    }
}

