/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.kaltura;

import com.google.inject.Inject;
import com.kaltura.client.RequestQueue;
import com.kaltura.client.services.MediaService;
import com.kaltura.client.types.MediaEntryFilter;
import com.kaltura.client.utils.response.base.Response;
import com.lucidworks.connector.plugins.kaltura.ClientWrapper;
import com.lucidworks.connector.plugins.kaltura.config.KalturaConfig;
import com.lucidworks.connector.plugins.kaltura.utils.SafeRequestExecutor;
import com.lucidworks.fusion.connector.plugin.api.config.ConnectorConfig;
import com.lucidworks.fusion.connector.plugin.api.validation.ValidationComponent;
import com.lucidworks.fusion.connector.plugin.api.validation.ValidationContext;
import com.lucidworks.fusion.connector.plugin.api.validation.result.ConnectorConfigValidationResult;
import com.lucidworks.fusion.schema.ValidationError;

public class ConfigurationValidator
implements ValidationComponent {
    private ClientWrapper clientWrapper;
    private KalturaConfig config;
    private RequestQueue executor;

    @Inject
    public ConfigurationValidator(ClientWrapper clientWrapper, KalturaConfig config, RequestQueue executor) {
        this.clientWrapper = clientWrapper;
        this.config = config;
        this.executor = executor;
    }

    public ConnectorConfigValidationResult validateConfig(ValidationContext validationContext) {
        ConnectorConfigValidationResult.Builder builder = ConnectorConfigValidationResult.builder((ConnectorConfig)this.config);
        try {
            Response resp = this.executor.execute(MediaService.list((MediaEntryFilter)new MediaEntryFilter()).build(this.clientWrapper.get()));
            if (resp != null && resp.error != null) {
                String errorMessage = resp.error.getMessage();
                String code = "settings-error";
                if (errorMessage != null && errorMessage.contains("Invalid KS")) {
                    code = "credential-error";
                }
                return ((ConnectorConfigValidationResult.Builder)builder.withErrors((Object[])new ValidationError[]{new ValidationError("", (Object)"", code, resp.error.getMessage())})).build();
            }
        }
        catch (Exception e) {
            if (SafeRequestExecutor.isGsonReflectionError(e)) {
                try {
                    SafeRequestExecutor safeExecutor = new SafeRequestExecutor();
                    Response<?> resp = safeExecutor.execute(MediaService.list((MediaEntryFilter)new MediaEntryFilter()).build(this.clientWrapper.get()));
                    if (resp != null && resp.error != null) {
                        String errorMessage = resp.error.getMessage();
                        String code = "settings-error";
                        if (errorMessage != null && errorMessage.contains("Invalid KS")) {
                            code = "credential-error";
                        }
                        return ((ConnectorConfigValidationResult.Builder)builder.withErrors((Object[])new ValidationError[]{new ValidationError("", (Object)"", code, resp.error.getMessage())})).build();
                    }
                }
                catch (Exception safeEx) {
                    return ((ConnectorConfigValidationResult.Builder)builder.withErrors((Object[])new ValidationError[]{new ValidationError("", (Object)"", "settings-error", "Failed to validate configuration: " + safeEx.getMessage())})).build();
                }
            }
            return ((ConnectorConfigValidationResult.Builder)builder.withErrors((Object[])new ValidationError[]{new ValidationError("", (Object)"", "settings-error", "Failed to validate configuration: " + e.getMessage())})).build();
        }
        return builder.build();
    }
}

