/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.kaltura;

import com.kaltura.client.Client;
import com.kaltura.client.Configuration;
import com.kaltura.client.enums.SessionType;
import com.kaltura.client.utils.request.ConnectionConfiguration;
import com.lucidworks.connector.plugins.kaltura.config.ConfigWrapper;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;

public class ClientWrapper {
    private ConfigWrapper config;
    private Client client;

    @Inject
    public ClientWrapper(ConfigWrapper config) throws Exception {
        Configuration kalturaConfig = new Configuration();
        kalturaConfig.setEndpoint(config.getEndpoint());
        String proxy = config.getProxy();
        Integer proxyPort = config.getProxyPort();
        if (StringUtils.isNotEmpty((String)proxy)) {
            kalturaConfig.setProxy(proxy);
        }
        if (proxyPort != null) {
            kalturaConfig.setProxyPort(proxyPort.intValue());
        }
        Client kalturaClient = new Client((ConnectionConfiguration)kalturaConfig);
        String ks = kalturaClient.generateSessionV2(config.getUserSecret(), config.getUserId(), SessionType.ADMIN, config.getPartnerId(), 86400, "*,disableentitlement");
        kalturaClient.setSessionId(ks);
        this.client = kalturaClient;
    }

    public Client get() {
        return this.client;
    }
}

