/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.fusion.connector.checker.checkers.depth;

import com.lucidworks.fusion.connector.checker.checkers.Checker;
import com.lucidworks.fusion.connector.checker.config.DepthLimitConfig;
import com.lucidworks.fusion.connector.checker.input.PathCheckerInput;
import com.lucidworks.fusion.connector.checker.output.CheckerResult;
import com.lucidworks.fusion.connector.checker.output.FailedCheckerResult;
import com.lucidworks.fusion.connector.checker.output.PassedCheckerResult;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepthChecker
implements Checker<PathCheckerInput> {
    private static final Logger logger = LoggerFactory.getLogger(DepthChecker.class);
    public static final String TOO_DEEP = "too-deep";
    private final DepthLimitConfig.Properties config;

    public DepthChecker(DepthLimitConfig.Properties config) {
        this.config = config;
    }

    public static int getItemDepth(PathCheckerInput checkerInput) {
        return Optional.ofNullable(checkerInput.getPaths()).filter(c -> !c.isEmpty()).orElseGet(() -> Collections.singletonList(checkerInput.getPath())).stream().mapToInt(p -> Paths.get(p, new String[0]).getNameCount()).max().orElse(0);
    }

    @Override
    public CheckerResult apply(PathCheckerInput input) {
        if (this.config.maxDepth() == -1) {
            return new PassedCheckerResult();
        }
        try {
            int itemDepth = DepthChecker.getItemDepth(input);
            return itemDepth <= this.config.maxDepth() ? new PassedCheckerResult() : FailedCheckerResult.failedResult(TOO_DEEP);
        }
        catch (InvalidPathException e) {
            logger.error("Invalid path", (Throwable)e);
            return FailedCheckerResult.failedResult("invalid-item");
        }
    }
}

