/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.validation;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.lucidworks.connector.plugins.jdbc.client.connection.datasource.JdbcDataSource;
import com.lucidworks.connector.plugins.jdbc.config.JdbcConfig;
import com.lucidworks.connector.plugins.jdbc.exception.JdbcRuntimeException;
import com.lucidworks.connector.plugins.jdbc.inject.provider.JdbcDataSourceFactory;
import com.lucidworks.connector.plugins.jdbc.input.JdbcQuery;
import com.lucidworks.connector.plugins.jdbc.validation.JdbConnectionValidationResult;
import com.lucidworks.fusion.connector.plugin.api.config.ConnectorConfig;
import com.lucidworks.fusion.connector.plugin.api.validation.ValidationComponent;
import com.lucidworks.fusion.connector.plugin.api.validation.ValidationContext;
import com.lucidworks.fusion.connector.plugin.api.validation.result.ConnectorConfigValidationResult;
import com.lucidworks.fusion.schema.ValidationError;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigValidator
implements ValidationComponent {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(ConfigValidator.class);
    private static final Pattern SELECT_STAR_PATTERN = Pattern.compile("(?i)SELECT(?>\\s+)\\*(?>\\s+)FROM", 2);
    private final JdbcConfig config;
    private final JdbcDataSourceFactory jdbcDataSourceFactory;

    @Inject
    public ConfigValidator(JdbcConfig config, JdbcDataSourceFactory jdbcDataSourceFactory) {
        this.config = config;
        this.jdbcDataSourceFactory = jdbcDataSourceFactory;
    }

    public ConnectorConfigValidationResult validateConfig(ValidationContext validationContext) {
        JdbConnectionValidationResult result;
        ConnectorConfigValidationResult binaryValidation;
        if (Strings.isNullOrEmpty((String)this.config.properties().query())) {
            return this.result(this.getErrorResult("query", "Query is required"));
        }
        if (Strings.isNullOrEmpty((String)this.config.properties().url())) {
            return this.result(this.getErrorResult("url", "Url is required"));
        }
        if (this.urlContainsCredentials()) {
            return this.result(this.getErrorResult("url", "Url must not contain username and credentials"));
        }
        if (Boolean.TRUE.equals(this.config.properties().strayContentDeletionEnabled()) && !Strings.isNullOrEmpty((String)this.config.properties().deltaQuery())) {
            return this.result(this.getErrorResult("delta query", "Delta Query cannot be used while Stray Content Deletion is enabled"));
        }
        if (this.hasBinaryContentColumnName() && (binaryValidation = this.validateBinaryContentConfig()).hasErrors()) {
            return binaryValidation;
        }
        if (Boolean.FALSE.equals(this.config.properties().skipValidation()) && !(result = this.jdbcConnectionSuccessful()).isConnectionSuccessful()) {
            return this.result(this.getErrorResult(result.field(), result.message()));
        }
        return this.result(new ValidationError[0]);
    }

    public ConnectorConfigValidationResult result(ValidationError ... errors) {
        return ((ConnectorConfigValidationResult.Builder)ConnectorConfigValidationResult.builder((ConnectorConfig)this.config).withErrors((Object[])errors)).build();
    }

    private boolean urlContainsCredentials() {
        String url = this.config.properties().url();
        if (this.isUrlOracleAndContainCredentials(url)) {
            return true;
        }
        return this.urlContainsCredentials(url);
    }

    private boolean isUrlOracleAndContainCredentials(String url) {
        return url.contains("oracle") && !url.contains(":@");
    }

    private boolean urlContainsCredentials(String url) {
        String[] parts = url.split("/");
        return url.contains("user=") || url.contains("password=") || parts.length >= 3 && parts[2].contains("@");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JdbConnectionValidationResult jdbcConnectionSuccessful() {
        String query = JdbcQuery.builder().query(this.config.properties().query()).limit(5).offset(0).build().sql();
        logger.info("Validating query: {}", (Object)query);
        try (JdbcDataSource dataSource = this.jdbcDataSourceFactory.get();
             Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.setMaxRows(1);
            try (ResultSet resultSet = statement.executeQuery(query);){
                if (this.queryResultValid(resultSet)) return JdbConnectionValidationResult.builder(true).build();
                JdbConnectionValidationResult jdbConnectionValidationResult = JdbConnectionValidationResult.builder(false).field("query").message("Could not get any results from given query").build();
                return jdbConnectionValidationResult;
            }
        }
        catch (JdbcRuntimeException e) {
            logger.error("Configuration validation error: {}", (Object)e.getMessage(), (Object)e);
            return JdbConnectionValidationResult.builder(false).field("driver").message(e.getMessage()).build();
        }
        catch (SQLException e) {
            logger.error("Configuration validation error: {}", (Object)e.getMessage(), (Object)e);
            return JdbConnectionValidationResult.builder(false).field("query").message(e.getMessage()).build();
        }
        catch (Exception e) {
            logger.error("Configuration validation error: {}", (Object)e.getMessage(), (Object)e);
            return JdbConnectionValidationResult.builder(false).field(this.getFieldForMessage(e.getMessage())).message(e.getMessage()).build();
        }
    }

    private boolean queryResultValid(ResultSet resultSet) throws SQLException {
        return resultSet.next();
    }

    private String getFieldForMessage(String message) {
        if (message.contains("Access denied")) {
            return "username or password";
        }
        if (message.contains("Communications link failure") || message.contains("claims to not accept")) {
            return "url";
        }
        return "unidentified";
    }

    private ValidationError getErrorResult(String field, String message) {
        return new ValidationError(field, (Object)"", "", message);
    }

    private boolean hasBinaryContentColumnName() {
        if (this.config.properties().binaryContent() == null) {
            return false;
        }
        String value = this.config.properties().binaryContent().binaryContentColumnName();
        return value != null && !value.trim().isEmpty();
    }

    private ConnectorConfigValidationResult validateBinaryContentConfig() {
        String binaryFileColumnName;
        String query = this.config.properties().query();
        String binaryColumnName = this.config.properties().binaryContent().binaryContentColumnName();
        String primaryKey = this.config.properties().primaryKey();
        if (SELECT_STAR_PATTERN.matcher(query).find()) {
            return this.result(this.getErrorResult("binaryContentColumnName", "Binary Content Column cannot be used with 'SELECT *' queries. Please list one or more columns in your query for proper binary content handling."));
        }
        if (!query.toLowerCase().contains(binaryColumnName.toLowerCase())) {
            return this.result(this.getErrorResult("binaryContentColumnName", String.format("Binary Content Column '%s' must be included in the SQL query. Please add '%s' to your SELECT statement.", binaryColumnName, binaryColumnName)));
        }
        if (!query.toLowerCase().contains(primaryKey.toLowerCase())) {
            return this.result(this.getErrorResult("primaryKey", String.format("Primary Key column '%s' must be included in the SQL query when indexing Binary Content. Please add '%s' to your SELECT statement.", primaryKey, primaryKey)));
        }
        if (!Strings.isNullOrEmpty((String)this.config.properties().deltaQuery())) {
            logger.warn("Binary content is configured with delta query. Note that binary content will be fetched separately for each row, which may impact performance during incremental crawls.");
        }
        String string = binaryFileColumnName = this.config.properties().binaryContent() != null ? this.config.properties().binaryContent().binaryFileColumnName() : null;
        if (Strings.isNullOrEmpty(binaryFileColumnName)) {
            logger.info("Binary File Column Name not specified. Filename will be auto-detected from common column patterns (e.g., 'FileName', 'Name', 'DocumentName').");
        }
        return this.result(new ValidationError[0]);
    }
}

