/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.inject;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.jdbc.inject.provider.DriverPath;
import com.lucidworks.fusion.connector.plugin.api.resource.BlobResource;
import com.lucidworks.fusion.connector.plugin.api.resource.BlobResourceClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriversDownloader {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(DriversDownloader.class);
    private final Path driversPath;
    private final BlobResourceClient blobResourceClient;

    @Inject
    public DriversDownloader(DriverPath path, BlobResourceClient blobResourceClient) {
        this.driversPath = path.get();
        this.blobResourceClient = blobResourceClient;
    }

    public Path download() {
        this.driversToDownload().forEach(DriverJar::downloadDriver);
        return this.driversPath;
    }

    List<DriverJar> driversToDownload() {
        return this.blobResourceClient.getByType("driver:jdbc").stream().map(x$0 -> new DriverJar((BlobResource)x$0)).filter(j -> !j.exists()).collect(Collectors.toList());
    }

    class DriverJar {
        final String id;
        final Path path;

        DriverJar(BlobResource resource) {
            this.id = resource.getId();
            this.path = DriversDownloader.this.driversPath.resolve(resource.getId());
        }

        boolean exists() {
            boolean exists = Files.exists(this.path, new LinkOption[0]);
            logger.info("The driver jar path={} exists[{}].", (Object)this.path, (Object)exists);
            return exists;
        }

        void downloadDriver() {
            Optional ois = DriversDownloader.this.blobResourceClient.getInputStream(this.id);
            if (ois.isEmpty()) {
                logger.warn("Can't download blob={}, the InputStream is not present.", (Object)this.id);
                return;
            }
            try (InputStream zis = (InputStream)ois.get();){
                logger.info("writing driver jar to path={}", (Object)this.path);
                Files.write(this.path, zis.readAllBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                logger.error("Error downloading blob - try restarting the plugin service", (Throwable)e);
            }
        }
    }
}

