/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.inject;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.jdbc.config.JdbcConfig;
import com.lucidworks.connector.plugins.jdbc.inject.CachingClassLoader;
import com.lucidworks.connector.plugins.jdbc.inject.DriversDownloader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriversClassLoader {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(DriversClassLoader.class);
    private static final CachingClassLoader classLoader = new CachingClassLoader(DriversClassLoader.class.getClassLoader());
    private final JdbcConfig config;
    private final DriversDownloader drivers;

    @Inject
    public DriversClassLoader(JdbcConfig config, DriversDownloader drivers) {
        this.config = config;
        this.drivers = drivers;
    }

    public void load() throws ClassNotFoundException {
        URL[] urls = this.drivers();
        int chainDepthBefore = classLoader.getChainDepth();
        int loadedUrlsBefore = classLoader.getLoadedUrlCount();
        classLoader.addUrls(urls);
        int chainDepthAfter = classLoader.getChainDepth();
        int loadedUrlsAfter = classLoader.getLoadedUrlCount();
        if (chainDepthAfter > chainDepthBefore) {
            logger.info("Added new classloader to chain. Depth: {} -> {}, Unique URLs: {} -> {}", new Object[]{chainDepthBefore, chainDepthAfter, loadedUrlsBefore, loadedUrlsAfter});
        } else {
            logger.debug("Skipped duplicate URL loading. Chain depth: {}, Unique URLs: {}", (Object)chainDepthAfter, (Object)loadedUrlsAfter);
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        Class.forName(this.config.properties().driver(), false, classLoader);
    }

    URL[] drivers() {
        Path driversPath = this.drivers.download();
        File[] files = driversPath.toFile().listFiles();
        if (files == null) {
            logger.warn("Empty drivers path.");
            return new URL[0];
        }
        return (URL[])Stream.of(files).filter(file -> !file.isDirectory()).filter(file -> file.getName().endsWith("jar")).map(f -> {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.warn("Problem getting the driver URL, continuing ...", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toArray(URL[]::new);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return Class.forName(className, false, classLoader);
    }
}

