/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.inject;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class CachingClassLoader
extends ClassLoader {
    private static final int MAX_CLASSLOADER_CHAIN_DEPTH = 100;
    private final Deque<ClassLoader> classLoaders = new ArrayDeque<ClassLoader>();
    private final Set<String> loadedUrls = new HashSet<String>();
    private final Object lock = new Object();

    public CachingClassLoader(ClassLoader parent) {
        this.classLoaders.push(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUrls(URL ... urls) {
        Object object = this.lock;
        synchronized (object) {
            HashSet<String> urlStrings = new HashSet<String>();
            for (URL url : urls) {
                urlStrings.add(url.toString());
            }
            if (this.loadedUrls.containsAll(urlStrings)) {
                return;
            }
            if (this.classLoaders.size() >= 100) {
                throw new IllegalStateException(String.format("ClassLoader chain depth exceeded maximum of %d. This indicates repeated calls to load() without proper cleanup. Current depth: %d, Loaded URLs: %d", 100, this.classLoaders.size(), this.loadedUrls.size()));
            }
            this.loadedUrls.addAll(urlStrings);
            this.classLoaders.push(new URLClassLoader(urls, this.getCurrentClassLoader()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getCurrentClassLoader() {
        Object object = this.lock;
        synchronized (object) {
            return this.classLoaders.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChainDepth() {
        Object object = this.lock;
        synchronized (object) {
            return this.classLoaders.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLoadedUrlCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.loadedUrls.size();
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.getCurrentClassLoader().loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        return this.getCurrentClassLoader().getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getCurrentClassLoader().getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.getCurrentClassLoader().getResourceAsStream(name);
    }
}

