/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.fetcher.processor;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.jdbc.client.BinaryContent;
import com.lucidworks.connector.plugins.jdbc.client.Client;
import com.lucidworks.connector.plugins.jdbc.client.nestedquery.NestedQueryResolver;
import com.lucidworks.connector.plugins.jdbc.exception.JdbcException;
import com.lucidworks.connector.plugins.jdbc.fetcher.configurator.ConfigWrapper;
import com.lucidworks.connector.plugins.jdbc.fetcher.output.JdbcTypedDocument;
import com.lucidworks.connector.plugins.jdbc.fetcher.output.JdbcTypedInputStreamContent;
import com.lucidworks.connector.plugins.jdbc.input.RowInput;
import com.lucidworks.connectors.components.processor.Processor;
import com.lucidworks.connectors.components.processor.TypedEmitter;
import com.lucidworks.connectors.components.processor.model.GsonModel;
import com.lucidworks.fusion.connector.plugin.api.exceptions.ContentEmitException;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.FetchResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowProcessor
extends Processor<RowInput> {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(RowProcessor.class);
    private final NestedQueryResolver nestedQueryResolver;
    private final Client client;
    private final ConfigWrapper config;

    @Inject
    public RowProcessor(NestedQueryResolver nestedQueryResolver, Client client, ConfigWrapper config) {
        this.nestedQueryResolver = nestedQueryResolver;
        this.client = client;
        this.config = config;
    }

    public FetchResult process(TypedEmitter ctx, RowInput input) {
        try {
            logger.info("Processing row with ID [{}]", (Object)input.inputId());
            HashMap<String, Object> document = new HashMap<String, Object>(input.document());
            if (this.config.hasNestedQueries()) {
                Map<String, List<Object>> nested = this.nestedQueryResolver.getNestedQueries(input.inputId(), document.keySet());
                document.putAll(nested);
            }
            if (this.config.hasBinaryContentColumnName()) {
                this.emitBinaryContent(ctx, input, document);
            } else {
                ctx.emitDocument(() -> new JdbcTypedDocument(input, document));
            }
        }
        catch (JdbcException e) {
            logger.error("Error while processing row", (Throwable)e);
            ctx.emitError((GsonModel.TypedInput)input, e.getMessage());
        }
        catch (ContentEmitException e) {
            logger.error("Error while emitting binary content", (Throwable)e);
            ctx.emitError((GsonModel.TypedInput)input, e.getMessage());
        }
        return ctx.newResult();
    }

    private void emitBinaryContent(TypedEmitter ctx, RowInput input, HashMap<String, Object> document) throws ContentEmitException, JdbcException {
        Object primaryKeyValue = document.get(this.config.primaryKey());
        if (primaryKeyValue == null) {
            logger.warn("Primary key [{}] not found in document. Skipping binary content.", (Object)this.config.primaryKey());
            ctx.emitDocument(() -> new JdbcTypedDocument(input, document));
            return;
        }
        logger.debug("Fetching binary content for row with primary key: {}", primaryKeyValue);
        BinaryContent binaryContent = this.client.fetchBinaryContent(this.config.query(), this.config.primaryKey(), primaryKeyValue, this.config.binaryContentColumnName(), document, this.config.binaryFileColumnName());
        if (binaryContent == null || binaryContent.getInputStream() == null) {
            logger.warn("No binary content found for row {}. Emitting as regular document.", primaryKeyValue);
            ctx.emitDocument(() -> new JdbcTypedDocument(input, document));
            return;
        }
        JdbcTypedInputStreamContent content = new JdbcTypedInputStreamContent(input, document, binaryContent);
        ctx.emitContentOrThrow(() -> content);
        logger.debug("Emitted binary content for row {}", primaryKeyValue);
    }
}

