/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.fetcher.processor;

import com.google.common.base.Strings;
import com.lucidworks.connector.plugins.jdbc.client.Client;
import com.lucidworks.connector.plugins.jdbc.config.JdbcConfig;
import com.lucidworks.connector.plugins.jdbc.fetcher.paginator.Paginator;
import com.lucidworks.connector.plugins.jdbc.input.CheckpointInput;
import com.lucidworks.connector.plugins.jdbc.input.PageInput;
import com.lucidworks.connectors.components.processor.Processor;
import com.lucidworks.connectors.components.processor.TypedEmitter;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.FetchResult;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointProcessor
extends Processor<CheckpointInput> {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(CheckpointProcessor.class);
    public static final String LAST_INDEX_TIME_VAR = "${last_index_time}";
    private final JdbcConfig.Properties properties;
    private final Paginator paginator;

    @Inject
    public CheckpointProcessor(JdbcConfig config, Client client) {
        this.properties = config.properties();
        this.paginator = new Paginator(client);
    }

    public FetchResult process(TypedEmitter ctx, CheckpointInput input) {
        String query = this.paginator.getPaginatedQueryIfAvailable(this.properties);
        if (!Strings.isNullOrEmpty((String)this.properties.deltaQuery())) {
            query = this.properties.deltaQuery().replace(LAST_INDEX_TIME_VAR, input.created());
            logger.info("Delta query will be used. delta query = [{}]", (Object)query);
        }
        PageInput pageInput = PageInput.builder().query(query).offset(0).parentId("root").build();
        ctx.emitCandidate(pageInput::toCandidate);
        return ctx.newResult();
    }
}

