/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.fetcher.output;

import com.lucidworks.connector.plugins.jdbc.input.RowInput;
import com.lucidworks.connectors.components.processor.model.TypedDocument;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.builders.MapBuilder;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTypedDocument
implements TypedDocument {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(JdbcTypedDocument.class);
    private final RowInput input;
    private final Map<String, Object> fields;

    public JdbcTypedDocument(RowInput input, Map<String, Object> fields) {
        this.input = input;
        this.fields = fields;
    }

    public Consumer<MapBuilder> metadata() {
        return m -> {};
    }

    public Consumer<MapBuilder> fields() {
        return JdbcTypedDocument.toMapBuilder(this.fields);
    }

    public String parentId() {
        return this.input.parentId();
    }

    public String getId() {
        return this.input.inputId();
    }

    public static Consumer<MapBuilder> toMapBuilder(Map<String, Object> map) {
        return m -> map.forEach((k, v) -> {
            if (v == null) {
                logger.warn("Skipping null value from key={}", k);
            } else if (v instanceof Integer) {
                m.setInteger(k, (Integer)v);
            } else if (v instanceof Long) {
                m.setLong(k, (Long)v);
            } else if (v instanceof Float) {
                m.setFloat(k, (Float)v);
            } else if (v instanceof Double) {
                m.setDouble(k, (Double)v);
            } else if (v instanceof Clob) {
                m.setString(k, JdbcTypedDocument.fromClob((Clob)v));
            } else if (v instanceof BigInteger) {
                m.setLong(k, Long.valueOf(((BigInteger)v).longValue()));
            } else if (v instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)v;
                if (bigDecimal.signum() == 0 || bigDecimal.scale() <= 0 || bigDecimal.stripTrailingZeros().scale() <= 0) {
                    m.setLong(k, Long.valueOf(bigDecimal.longValue()));
                } else {
                    m.setDouble(k, Double.valueOf(bigDecimal.doubleValue()));
                }
            } else if (v instanceof String) {
                m.setString(k, (String)v);
            } else if (v instanceof Boolean) {
                m.setBoolean(k, (Boolean)v);
            } else if (v instanceof Timestamp) {
                m.setLocalDateTime(k, ((Timestamp)v).toLocalDateTime());
            } else if (v instanceof LocalDateTime) {
                m.setLocalDateTime(k, (LocalDateTime)v);
            } else if (v instanceof Date) {
                m.setDate(k, (Date)v);
            } else if (v instanceof Collection) {
                try {
                    JdbcTypedDocument.fromColl(k, (Collection)v, m);
                }
                catch (Exception ex) {
                    logger.warn("Metadata with key={} not added", k);
                    logger.debug("Problem adding collection Metadata with key={}", k, (Object)ex);
                }
            } else {
                logger.warn("Metadata with key={}, type={} not added", k, v.getClass());
            }
        });
    }

    private static void fromColl(String key, Collection<?> values, MapBuilder mapBuilder) {
        Set types = values.stream().filter(Objects::nonNull).map(Object::getClass).collect(Collectors.toSet());
        if (types.size() == 1) {
            Class clazz = (Class)types.iterator().next();
            if (clazz.isAssignableFrom(Clob.class)) {
                List strings = values.stream().filter(Objects::nonNull).map(object -> JdbcTypedDocument.fromClob((Clob)object)).collect(Collectors.toList());
                mapBuilder.setStrings(key, strings);
            } else if (clazz.isAssignableFrom(Integer.class)) {
                List integers = values.stream().filter(Objects::nonNull).map(Integer.class::cast).collect(Collectors.toList());
                mapBuilder.setIntegers(key, integers);
            } else if (clazz.isAssignableFrom(Long.class)) {
                List longs = values.stream().filter(Objects::nonNull).map(Long.class::cast).collect(Collectors.toList());
                mapBuilder.setLongs(key, longs);
            } else if (clazz.isAssignableFrom(Float.class)) {
                List floats = values.stream().filter(Objects::nonNull).map(Float.class::cast).collect(Collectors.toList());
                mapBuilder.setFloats(key, floats);
            } else if (clazz.isAssignableFrom(Double.class)) {
                List doubles = values.stream().filter(Objects::nonNull).map(Double.class::cast).collect(Collectors.toList());
                mapBuilder.setDoubles(key, doubles);
            } else if (clazz.isAssignableFrom(BigInteger.class)) {
                List longs = values.stream().filter(Objects::nonNull).map(object -> ((BigInteger)object).longValue()).collect(Collectors.toList());
                mapBuilder.setLongs(key, longs);
            } else if (clazz.isAssignableFrom(BigDecimal.class)) {
                List doubles = values.stream().filter(Objects::nonNull).map(object -> ((BigDecimal)object).doubleValue()).collect(Collectors.toList());
                mapBuilder.setDoubles(key, doubles);
            } else if (clazz.isAssignableFrom(String.class)) {
                List strings = values.stream().filter(Objects::nonNull).map(String.class::cast).collect(Collectors.toList());
                mapBuilder.setStrings(key, strings);
            } else if (clazz.isAssignableFrom(Timestamp.class)) {
                List dates = values.stream().filter(Objects::nonNull).map(object -> ((Timestamp)object).toLocalDateTime()).collect(Collectors.toList());
                mapBuilder.setLocalDateTimes(key, dates);
            } else if (clazz.isAssignableFrom(Boolean.class)) {
                List booleans = values.stream().filter(Objects::nonNull).map(Boolean.class::cast).collect(Collectors.toList());
                mapBuilder.setBooleans(key, booleans);
            } else if (clazz.isAssignableFrom(LocalDateTime.class)) {
                List dates = values.stream().filter(Objects::nonNull).map(LocalDateTime.class::cast).collect(Collectors.toList());
                mapBuilder.setLocalDateTimes(key, dates);
            } else if (clazz.isAssignableFrom(Date.class)) {
                List dates = values.stream().filter(Objects::nonNull).map(Date.class::cast).collect(Collectors.toList());
                mapBuilder.setDates(key, dates);
            } else {
                logger.warn("Metadata with key={} not added", (Object)key);
            }
        } else {
            List strings = values.stream().filter(Objects::nonNull).map(object -> Objects.toString(object, "NULL")).collect(Collectors.toList());
            mapBuilder.setStrings(key, strings);
        }
    }

    private static String fromClob(Clob clob) {
        try {
            Reader characterStream = clob.getCharacterStream();
            StringBuilder stringBuilder = new StringBuilder();
            int character = characterStream.read();
            while (character != -1) {
                stringBuilder.append((char)character);
                character = characterStream.read();
            }
            characterStream.close();
            return stringBuilder.toString();
        }
        catch (Exception e) {
            logger.warn("Problem reading CLOB {}", (Object)e.getMessage());
            logger.debug("CLOB Error", (Throwable)e);
            return "-error-";
        }
    }
}

