/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.fetcher.configurator;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.jdbc.config.JdbcConfig;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ConfigWrapper {
    private final JdbcConfig config;
    private final boolean hasNestedQueries;
    private final List<String> nestedQueries;

    @Inject
    public ConfigWrapper(JdbcConfig config) {
        this.config = config;
        this.hasNestedQueries = Optional.ofNullable(config.properties()).map(JdbcConfig.Properties::nestedQueries).map(nestedQ -> !nestedQ.isEmpty()).orElse(false);
        this.nestedQueries = Optional.ofNullable(config.properties()).map(JdbcConfig.Properties::nestedQueries).orElse(Collections.emptyList());
    }

    public boolean hasNestedQueries() {
        return this.hasNestedQueries;
    }

    public int maxConnections() {
        return this.config.properties().maxConnections();
    }

    public List<String> nestedQueries() {
        return this.nestedQueries;
    }

    public int nestedQueryTimeOut() {
        return this.config.properties().nestedQueryTimeOut();
    }

    public int batchSize() {
        return this.config.properties().batchSize();
    }

    public String primaryKey() {
        return this.config.properties().primaryKey();
    }

    public boolean strayContentDeletionEnabled() {
        return Boolean.TRUE.equals(this.config.properties().strayContentDeletionEnabled());
    }

    public String binaryContentColumnName() {
        return Optional.ofNullable(this.config.properties().binaryContent()).map(binaryContent -> binaryContent.binaryContentColumnName()).orElse(null);
    }

    public boolean hasBinaryContentColumnName() {
        String value = this.binaryContentColumnName();
        return value != null && !value.trim().isEmpty();
    }

    public String binaryFileColumnName() {
        return Optional.ofNullable(this.config.properties().binaryContent()).map(binaryContent -> binaryContent.binaryFileColumnName()).orElse(null);
    }

    public boolean hasBinaryFileColumnName() {
        String value = this.binaryFileColumnName();
        return value != null && !value.trim().isEmpty();
    }

    public String query() {
        return this.config.properties().query();
    }

    public boolean enableAutomaticPagination() {
        return Boolean.TRUE.equals(this.config.properties().enableAutomaticPagination());
    }
}

