/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.client.result;

import com.lucidworks.connector.plugins.jdbc.exception.JdbcException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcQueryResult {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(JdbcQueryResult.class);
    private final Connection connection;
    private final Statement statement;
    private ResultSet resultSet;

    public JdbcQueryResult(Connection connection, Statement statement, ResultSet resultSet) {
        this.resultSet = resultSet;
        this.connection = connection;
        this.statement = statement;
    }

    public boolean hasNext() throws JdbcException {
        try {
            if (this.resultSet.next()) {
                return true;
            }
            if (!this.statement.getMoreResults() && this.statement.getUpdateCount() == -1) {
                return false;
            }
            this.resultSet = this.statement.getResultSet();
            return this.resultSet.next();
        }
        catch (SQLException e) {
            throw JdbcException.create(e.getMessage(), e);
        }
    }

    public <T> T getObject(int columnIndex, Class<T> type) throws JdbcException {
        try {
            return this.resultSet.getObject(columnIndex, type);
        }
        catch (SQLException e) {
            throw JdbcException.create(e.getMessage(), e);
        }
    }

    public ResultSetMetaData getMetaData() throws JdbcException {
        try {
            return this.resultSet.getMetaData();
        }
        catch (SQLException e) {
            throw JdbcException.create(e.getMessage(), e);
        }
    }

    public void close() {
        JdbcQueryResult.closeQuietly(this.resultSet);
        JdbcQueryResult.closeQuietly(this.statement);
        JdbcQueryResult.closeQuietly(this.connection);
    }

    private static void closeQuietly(AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (Exception e) {
            logger.error("Error while closing", (Throwable)e);
        }
    }
}

