/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.client.nestedquery;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.lucidworks.connector.plugins.jdbc.client.Client;
import com.lucidworks.connector.plugins.jdbc.client.row.JdbcRows;
import com.lucidworks.connector.plugins.jdbc.exception.JdbcException;
import com.lucidworks.connector.plugins.jdbc.exception.JdbcRuntimeException;
import com.lucidworks.connector.plugins.jdbc.fetcher.configurator.ConfigWrapper;
import com.lucidworks.connector.plugins.jdbc.input.JdbcNestedQuery;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedQueryResolver {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(NestedQueryResolver.class);
    private final Client client;
    private final ConfigWrapper configWrapper;
    private final ExecutorService executorService;

    @Inject
    public NestedQueryResolver(Client client, ConfigWrapper configWrapper) {
        this.client = client;
        this.configWrapper = configWrapper;
        this.executorService = Executors.newFixedThreadPool(configWrapper.maxConnections() + 1);
    }

    public Map<String, List<Object>> getNestedQueries(String primaryKey, Set<String> knownColumns) throws JdbcException {
        if (!this.configWrapper.hasNestedQueries()) {
            return Collections.emptyMap();
        }
        try {
            ImmutableMap.Builder results = ImmutableMap.builder();
            AtomicInteger counter = new AtomicInteger(0);
            List tasks = this.configWrapper.nestedQueries().stream().map(query -> {
                int index = counter.incrementAndGet();
                return this.executorService.submit(() -> this.executeAndFetchRows((String)query, primaryKey, knownColumns, index));
            }).collect(Collectors.toList());
            tasks.stream().map(future -> {
                try {
                    return (Map)future.get(this.configWrapper.nestedQueryTimeOut(), TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    throw JdbcRuntimeException.create(e.getMessage(), e);
                }
            }).forEach(arg_0 -> ((ImmutableMap.Builder)results).putAll(arg_0));
            return results.build();
        }
        catch (Exception e) {
            throw JdbcException.create(e.getMessage(), e);
        }
    }

    public void close() {
        try {
            this.executorService.shutdown();
            this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
            this.executorService.shutdownNow();
        }
        catch (Exception e) {
            logger.error("Error while shutting down executor service", (Throwable)e);
        }
    }

    private Map<String, List<Object>> executeAndFetchRows(String query, String primaryKey, Set<String> knownColumns, int index) throws Exception {
        String nestedFieldPrefix = String.format("nestedField%s", index);
        String nestedQuery = query.replace("${id}", primaryKey);
        JdbcNestedQuery jdbcNestedQuery = JdbcNestedQuery.builder().query(nestedQuery).fetchSize(this.configWrapper.batchSize()).knownColumns(knownColumns).fieldPrefix(nestedFieldPrefix).build();
        try (JdbcRows jdbcRows = this.client.executeNestedQuery(jdbcNestedQuery);){
            Map<String, List<Object>> map = jdbcRows.fetch();
            return map;
        }
    }
}

