/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.client.iterator;

import com.lucidworks.connector.plugins.jdbc.client.result.JdbcQueryResult;
import com.lucidworks.connector.plugins.jdbc.exception.JdbcRuntimeException;
import com.lucidworks.connector.plugins.jdbc.input.Column;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcIterator
implements Iterator<Map<String, Object>>,
AutoCloseable {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(JdbcIterator.class);
    private final JdbcQueryResult queryResult;
    private final List<Column> columns;
    private final AtomicInteger totalCount = new AtomicInteger(0);

    public JdbcIterator(JdbcQueryResult queryResult, List<Column> columns) {
        this.queryResult = queryResult;
        this.columns = columns;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.queryResult.hasNext();
        }
        catch (Exception e) {
            throw JdbcRuntimeException.create(e.getMessage(), e);
        }
    }

    @Override
    public Map<String, Object> next() {
        this.totalCount.incrementAndGet();
        HashMap<String, Object> document = new HashMap<String, Object>();
        this.columns.forEach(column -> {
            try {
                logger.debug("Column result of type={}", column.type());
                Object value = this.queryResult.getObject(column.index(), column.type());
                document.put(column.name(), value);
            }
            catch (Exception e) {
                logger.warn("Failed to retrieve column [{}] at index [{}] with type [{}]: {}. Skipping column.", new Object[]{column.name(), column.index(), column.type(), e.getMessage()});
                logger.debug("Column retrieval stack trace:", (Throwable)e);
            }
        });
        return document;
    }

    public int getTotalCount() {
        return this.totalCount.get();
    }

    @Override
    public void close() {
        this.queryResult.close();
    }
}

