/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.client;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedBinaryInputStream
extends InputStream {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(ManagedBinaryInputStream.class);
    private final InputStream delegate;
    private final ResultSet resultSet;
    private final PreparedStatement statement;
    private final Connection connection;
    private boolean closed = false;

    public ManagedBinaryInputStream(InputStream delegate, ResultSet resultSet, PreparedStatement statement, Connection connection) {
        this.delegate = delegate;
        this.resultSet = resultSet;
        this.statement = statement;
        this.connection = connection;
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.delegate.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.delegate.close();
        }
        finally {
            this.closeResources();
            this.closed = true;
        }
    }

    private void closeResources() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (Exception e) {
                logger.warn("Error closing ResultSet", (Throwable)e);
            }
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (Exception e) {
                logger.warn("Error closing Statement", (Throwable)e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                logger.warn("Error closing Connection", (Throwable)e);
            }
        }
    }
}

