/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.client;

import com.lucidworks.connector.plugins.jdbc.client.BinaryContent;
import com.lucidworks.connector.plugins.jdbc.client.Client;
import com.lucidworks.connector.plugins.jdbc.client.ContentTypeDetector;
import com.lucidworks.connector.plugins.jdbc.client.ManagedBinaryInputStream;
import com.lucidworks.connector.plugins.jdbc.client.column.ColumnResolver;
import com.lucidworks.connector.plugins.jdbc.client.connection.ConnectionPool;
import com.lucidworks.connector.plugins.jdbc.client.iterator.JdbcIterator;
import com.lucidworks.connector.plugins.jdbc.client.result.JdbcQueryResult;
import com.lucidworks.connector.plugins.jdbc.client.row.JdbcRows;
import com.lucidworks.connector.plugins.jdbc.exception.JdbcException;
import com.lucidworks.connector.plugins.jdbc.input.Column;
import com.lucidworks.connector.plugins.jdbc.input.JdbcNestedQuery;
import com.lucidworks.connector.plugins.jdbc.input.JdbcQuery;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClient
extends Client {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(DefaultClient.class);
    private static final Pattern LIMIT_PLACEHOLDER_PATTERN = Pattern.compile("(?i)(?>\\s+)LIMIT(?>\\s+)\\$\\{limit}", 2);
    private static final Pattern OFFSET_PLACEHOLDER_PATTERN = Pattern.compile("(?i)(?>\\s+)OFFSET(?>\\s+)\\$\\{offset}", 2);
    private static final Pattern LIMIT_NUMERIC_PATTERN = Pattern.compile("(?i)(?>\\s+)LIMIT(?>\\s+)\\d+", 2);
    private static final Pattern OFFSET_NUMERIC_PATTERN = Pattern.compile("(?i)(?>\\s+)OFFSET(?>\\s+)\\d+", 2);
    private static final Pattern SQLSERVER_PAGINATION_NUMERIC_PATTERN = Pattern.compile("(?i)(?>\\s+)OFFSET(?>\\s+)\\d+(?>\\s+)ROWS(?>\\s+)FETCH(?>\\s+)NEXT(?>\\s+)\\d+(?>\\s+)ROWS(?>\\s+)ONLY", 2);
    private static final Pattern SQLSERVER_PAGINATION_PLACEHOLDER_PATTERN = Pattern.compile("(?i)(?>\\s+)OFFSET(?>\\s+)\\$\\{offset}(?>\\s+)ROWS(?>\\s+)FETCH(?>\\s+)NEXT(?>\\s+)\\$\\{limit}(?>\\s+)ROWS(?>\\s+)ONLY", 2);
    private final ColumnResolver columnResolver;

    @Inject
    public DefaultClient(ConnectionPool connectionPool, ColumnResolver columnResolver) {
        super(connectionPool);
        this.columnResolver = columnResolver;
    }

    @Override
    public JdbcIterator executeQuery(JdbcQuery query) throws JdbcException {
        logger.debug("Query: [{}]", (Object)query.sql());
        JdbcQueryResult result = this.execute(query.sql(), query.limit());
        List<Column> columns = this.columnResolver.getColumns(result.getMetaData());
        return new JdbcIterator(result, columns);
    }

    @Override
    public JdbcRows executeNestedQuery(JdbcNestedQuery query) throws JdbcException {
        logger.info("Nested query: [{}]", (Object)query);
        JdbcQueryResult result = this.execute(query.query(), query.fetchSize());
        List<Column> columns = this.columnResolver.getNestedColumns(result.getMetaData(), query.knownColumns(), query.fieldPrefix());
        return new JdbcRows(result, columns);
    }

    @Override
    public BinaryContent fetchBinaryContent(String baseQuery, String primaryKeyColumn, Object primaryKeyValue, String binaryColumn, Map<String, Object> allFields, String resourceNameColumn) throws JdbcException {
        String sql = String.format("SELECT %s FROM (%s) binary_fetch WHERE %s = ?", binaryColumn, this.stripLimitOffset(baseQuery), primaryKeyColumn);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setObject(1, primaryKeyValue);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                logger.warn("No binary content found for primary key: {}", primaryKeyValue);
                this.closeQuietly(rs);
                this.closeQuietly(stmt);
                this.closeQuietly(conn);
                return null;
            }
            Object binaryData = rs.getObject(1);
            InputStream inputStream = this.convertToInputStream(binaryData);
            if (inputStream == null) {
                logger.warn("Binary content is NULL for primary key: {}. Skipping binary content.", primaryKeyValue);
                this.closeQuietly(rs);
                this.closeQuietly(stmt);
                this.closeQuietly(conn);
                return null;
            }
            String filename = ContentTypeDetector.findFilenameInFields(allFields, resourceNameColumn);
            String contentType = ContentTypeDetector.detectFromFilename(filename);
            if (contentType != null) {
                logger.debug("Auto-detected content type '{}' from filename '{}'", (Object)contentType, (Object)filename);
            } else if (filename != null) {
                logger.debug("Could not detect content type from filename '{}' - Tika will auto-detect", (Object)filename);
            } else {
                logger.debug("No filename found in fields - Tika will auto-detect content type");
            }
            ManagedBinaryInputStream managedStream = new ManagedBinaryInputStream(inputStream, rs, stmt, conn);
            return BinaryContent.builder().inputStream(managedStream).contentType(contentType).resourceName(filename).build();
        }
        catch (SQLException e) {
            this.closeQuietly(rs);
            this.closeQuietly(stmt);
            this.closeQuietly(conn);
            throw JdbcException.create(String.format("Failed to fetch binary content for primary key: %s", primaryKeyValue), e);
        }
    }

    private InputStream convertToInputStream(Object binaryData) throws SQLException {
        if (binaryData == null) {
            return null;
        }
        if (binaryData instanceof byte[]) {
            return new ByteArrayInputStream((byte[])binaryData);
        }
        if (binaryData instanceof Blob) {
            Blob blob = (Blob)binaryData;
            return blob.getBinaryStream();
        }
        if (binaryData instanceof InputStream) {
            return (InputStream)binaryData;
        }
        throw new IllegalArgumentException("Unsupported binary type: " + binaryData.getClass().getName());
    }

    private String stripLimitOffset(String query) {
        String stripped = SQLSERVER_PAGINATION_NUMERIC_PATTERN.matcher(query).replaceAll("");
        stripped = SQLSERVER_PAGINATION_PLACEHOLDER_PATTERN.matcher(stripped).replaceAll("");
        stripped = LIMIT_PLACEHOLDER_PATTERN.matcher(stripped).replaceAll("");
        stripped = OFFSET_PLACEHOLDER_PATTERN.matcher(stripped).replaceAll("");
        stripped = LIMIT_NUMERIC_PATTERN.matcher(stripped).replaceAll("");
        stripped = OFFSET_NUMERIC_PATTERN.matcher(stripped).replaceAll("");
        return stripped.trim();
    }

    private void closeQuietly(AutoCloseable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (Exception e) {
                logger.warn("Error closing resource", (Throwable)e);
            }
        }
    }
}

