/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.client;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContentTypeDetector {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(ContentTypeDetector.class);
    private static final Map<String, String> MIME_TYPES = new HashMap<String, String>();

    public static String detectFromFilename(String filename) {
        if (filename == null || filename.trim().isEmpty()) {
            return null;
        }
        String extension = ContentTypeDetector.getFileExtension(filename);
        if (extension == null) {
            return null;
        }
        String mimeType = MIME_TYPES.get(extension.toLowerCase());
        if (mimeType != null) {
            logger.debug("Detected content type '{}' from filename '{}'", (Object)mimeType, (Object)filename);
        } else {
            logger.debug("Unknown file extension '{}' for filename '{}'", (Object)extension, (Object)filename);
        }
        return mimeType;
    }

    private static String getFileExtension(String filename) {
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > 0 && lastDot < filename.length() - 1) {
            return filename.substring(lastDot + 1);
        }
        return null;
    }

    public static String findFilenameInFields(Map<String, Object> fields, String resourceNameColumn) {
        String[] filenameColumns;
        String filename;
        Object value;
        if (resourceNameColumn != null && !resourceNameColumn.trim().isEmpty() && (value = fields.get(resourceNameColumn)) != null && !(filename = String.valueOf(value)).trim().isEmpty()) {
            logger.debug("Found filename in configured resource name column '{}': {}", (Object)resourceNameColumn, (Object)filename);
            return filename;
        }
        for (String column : filenameColumns = new String[]{"filename", "file_name", "fileName", "name", "docname", "doc_name", "documentname", "document_name", "resourcename", "resource_name", "title"}) {
            for (Map.Entry<String, Object> entry : fields.entrySet()) {
                String value2;
                if (!entry.getKey().equalsIgnoreCase(column) || entry.getValue() == null || (value2 = String.valueOf(entry.getValue())).trim().isEmpty()) continue;
                logger.debug("Found potential filename in column '{}': {}", (Object)entry.getKey(), (Object)value2);
                return value2;
            }
        }
        return null;
    }

    @Generated
    private ContentTypeDetector() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        MIME_TYPES.put("pdf", "application/pdf");
        MIME_TYPES.put("doc", "application/msword");
        MIME_TYPES.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        MIME_TYPES.put("xls", "application/vnd.ms-excel");
        MIME_TYPES.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        MIME_TYPES.put("ppt", "application/vnd.ms-powerpoint");
        MIME_TYPES.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        MIME_TYPES.put("odt", "application/vnd.oasis.opendocument.text");
        MIME_TYPES.put("ods", "application/vnd.oasis.opendocument.spreadsheet");
        MIME_TYPES.put("odp", "application/vnd.oasis.opendocument.presentation");
        MIME_TYPES.put("txt", "text/plain");
        MIME_TYPES.put("rtf", "application/rtf");
        MIME_TYPES.put("csv", "text/csv");
        MIME_TYPES.put("xml", "application/xml");
        MIME_TYPES.put("html", "text/html");
        MIME_TYPES.put("htm", "text/html");
        MIME_TYPES.put("jpg", "image/jpeg");
        MIME_TYPES.put("jpeg", "image/jpeg");
        MIME_TYPES.put("png", "image/png");
        MIME_TYPES.put("gif", "image/gif");
        MIME_TYPES.put("bmp", "image/bmp");
        MIME_TYPES.put("tif", "image/tiff");
        MIME_TYPES.put("tiff", "image/tiff");
        MIME_TYPES.put("svg", "image/svg+xml");
        MIME_TYPES.put("ico", "image/x-icon");
        MIME_TYPES.put("webp", "image/webp");
        MIME_TYPES.put("zip", "application/zip");
        MIME_TYPES.put("tar", "application/x-tar");
        MIME_TYPES.put("gz", "application/gzip");
        MIME_TYPES.put("7z", "application/x-7z-compressed");
        MIME_TYPES.put("rar", "application/vnd.rar");
        MIME_TYPES.put("mp3", "audio/mpeg");
        MIME_TYPES.put("wav", "audio/wav");
        MIME_TYPES.put("ogg", "audio/ogg");
        MIME_TYPES.put("m4a", "audio/mp4");
        MIME_TYPES.put("flac", "audio/flac");
        MIME_TYPES.put("mp4", "video/mp4");
        MIME_TYPES.put("avi", "video/x-msvideo");
        MIME_TYPES.put("mov", "video/quicktime");
        MIME_TYPES.put("wmv", "video/x-ms-wmv");
        MIME_TYPES.put("flv", "video/x-flv");
        MIME_TYPES.put("webm", "video/webm");
        MIME_TYPES.put("mkv", "video/x-matroska");
        MIME_TYPES.put("json", "application/json");
        MIME_TYPES.put("js", "application/javascript");
        MIME_TYPES.put("css", "text/css");
    }
}

