/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.client;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.jdbc.client.BinaryContent;
import com.lucidworks.connector.plugins.jdbc.client.connection.ConnectionPool;
import com.lucidworks.connector.plugins.jdbc.client.iterator.JdbcIterator;
import com.lucidworks.connector.plugins.jdbc.client.result.JdbcQueryResult;
import com.lucidworks.connector.plugins.jdbc.client.row.JdbcRows;
import com.lucidworks.connector.plugins.jdbc.exception.JdbcException;
import com.lucidworks.connector.plugins.jdbc.input.JdbcNestedQuery;
import com.lucidworks.connector.plugins.jdbc.input.JdbcQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Client {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    private final ConnectionPool connectionPool;

    @Inject
    public Client(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public abstract JdbcIterator executeQuery(JdbcQuery var1) throws JdbcException;

    public abstract JdbcRows executeNestedQuery(JdbcNestedQuery var1) throws JdbcException;

    JdbcQueryResult execute(String sql, int fetchSize) throws JdbcException {
        try {
            Connection connection = this.getConnection();
            Statement statement = connection.createStatement(1003, 1007);
            statement.setFetchSize(fetchSize);
            ResultSet resultSet = statement.executeQuery(sql);
            return new JdbcQueryResult(connection, statement, resultSet);
        }
        catch (SQLException e) {
            throw JdbcException.create(e.getMessage(), e);
        }
    }

    public void close() {
        try {
            this.connectionPool.close();
        }
        catch (Exception e) {
            logger.error("Error while closing connection", (Throwable)e);
        }
    }

    protected Connection getConnection() throws JdbcException {
        try {
            return this.connectionPool.getConnection();
        }
        catch (Exception e) {
            throw JdbcException.create(e.getMessage(), e.getCause());
        }
    }

    public abstract BinaryContent fetchBinaryContent(String var1, String var2, Object var3, String var4, Map<String, Object> var5, String var6) throws JdbcException;

    public Double getDatabaseVersion() throws JdbcException {
        try {
            String databaseVersion = String.format("%s.%s", this.connectionPool.getConnection().getMetaData().getDatabaseMajorVersion(), this.connectionPool.getConnection().getMetaData().getDatabaseMinorVersion());
            return Double.parseDouble(databaseVersion);
        }
        catch (Exception e) {
            logger.error("Error getting or parsing database version", (Throwable)e);
            throw JdbcException.create(e.getMessage(), e.getCause());
        }
    }
}

