/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connectors.components.processor.model.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateTypeAdapter
extends TypeAdapter<LocalDate> {
    public void write(JsonWriter out, LocalDate value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.value(value.format(DateTimeFormatter.ISO_LOCAL_DATE));
        }
    }

    public LocalDate read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String isoString = in.nextString();
        return LocalDate.parse(isoString, DateTimeFormatter.ISO_LOCAL_DATE);
    }
}

