/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connectors.components.processor;

import com.lucidworks.connectors.components.processor.EmitterConfig;
import com.lucidworks.connectors.components.processor.Processor;
import com.lucidworks.connectors.components.processor.TypedEmitter;
import com.lucidworks.connectors.components.processor.model.GsonModel;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.FetchResult;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.ContentFetcher;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.FetchInput;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorRunner {
    private static final Logger logger = LoggerFactory.getLogger(ProcessorRunner.class);
    private final Map<String, Provider<Processor>> processors;
    private final EmitterConfig config;

    @Inject
    public ProcessorRunner(EmitterConfig config, Map<String, Provider<Processor>> processors) {
        this.processors = processors;
        this.config = config;
    }

    private <T extends GsonModel.TypedInput> Processor<?> get(Class<T> klazz) {
        String className = klazz.getCanonicalName();
        String noAuto = className.replace("AutoValue_", "");
        logger.trace("serialize clazz={} from={}", (Object)className, (Object)noAuto);
        return (Processor)this.processors.get(noAuto).get();
    }

    public FetchResult process(ContentFetcher.FetchContext ctx, FetchInput input) {
        GsonModel.TypedInput typedInput = GsonModel.of(input);
        String inputId = typedInput.inputId();
        String clazzSimpleName = typedInput.getClass().getSimpleName();
        logger.info("Fetching input.id={}, input.type={}", (Object)inputId, (Object)clazzSimpleName);
        logger.debug("Fetching input={}", (Object)typedInput);
        Processor<?> processor = this.get(typedInput.getClass());
        TypedEmitter emitter = new TypedEmitter(this.config, ctx);
        return processor.startProcess(emitter, typedInput);
    }
}

