/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connectors.components.processor;

import com.google.common.reflect.TypeToken;
import com.lucidworks.connectors.components.processor.TypedEmitter;
import com.lucidworks.connectors.components.processor.model.GsonModel;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.FetchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Processor<T extends GsonModel.TypedInput> {
    private static final Logger logger = LoggerFactory.getLogger(Processor.class);
    private final TypeToken<T> type = new TypeToken<T>(this.getClass()){};

    public Class<T> getProcessorType() {
        return this.type.getRawType();
    }

    public abstract FetchResult process(TypedEmitter var1, T var2);

    FetchResult startProcess(TypedEmitter ctx, GsonModel.TypedInput input) {
        try {
            return this.process(ctx, (GsonModel.TypedInput)this.getProcessorType().cast(input));
        }
        catch (Exception ex) {
            logger.warn("Triggering the safeguard error for inputId={}.", (Object)input.inputId(), (Object)ex);
            ctx.emitErrorWithNoRetry(input, ex.getMessage());
            return ctx.newResult();
        }
    }
}

