/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connectors.components.injector;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Singleton;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.OptionalBinder;
import com.lucidworks.connectors.components.processor.EmitterConfig;
import com.lucidworks.connectors.components.processor.Processor;
import com.lucidworks.connectors.components.processors.IncompatibleDataInput;
import com.lucidworks.connectors.components.processors.content.IncompatibleDataProcessor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(ProcessorModule.class);
    private final Set<String> packagePrefix;

    public ProcessorModule(String ... packagePrefix) {
        this.packagePrefix = new HashSet<String>(Arrays.asList(packagePrefix));
    }

    protected void configure() {
        MapBinder binder = MapBinder.newMapBinder((Binder)this.binder(), String.class, Processor.class);
        binder.addBinding((Object)IncompatibleDataInput.class.getCanonicalName()).to(IncompatibleDataProcessor.class).in(Singleton.class);
        this.packagePrefix.forEach(p -> this.bindClasses(this.scanPackages((String)p), (MapBinder<String, Processor>)binder));
        OptionalBinder.newOptionalBinder((Binder)this.binder(), EmitterConfig.class).setDefault().toInstance((Object)EmitterConfig.builder().retryPolicyEnabled(false).build());
    }

    private void bindClasses(Set<Class<? extends Processor>> processors, MapBinder<String, Processor> binder) {
        logger.debug("Binding Processors.size={}", (Object)processors.size());
        for (Class<? extends Processor> processor : processors) {
            String typeName = processor.getGenericSuperclass().getTypeName();
            String[] split = typeName.split("<");
            String generic = split[1];
            generic = generic.substring(0, generic.length() - 1);
            logger.debug("Binding class={}, genericSuperclass={}, generics={}", new Object[]{processor.getCanonicalName(), typeName, generic});
            binder.addBinding((Object)generic).to(processor).in(Singleton.class);
        }
    }

    private Set<Class<? extends Processor>> scanPackages(String packagePrefix) {
        logger.debug("Start package scanner={}", (Object)packagePrefix);
        Reflections internal = new Reflections(packagePrefix, new Scanner[0]);
        return internal.getSubTypesOf(Processor.class);
    }
}

