/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.inject.provider;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.lucidworks.connector.plugins.jdbc.client.connection.datasource.JdbcDataSource;
import com.lucidworks.connector.plugins.jdbc.config.JdbcConfig;
import com.lucidworks.connector.plugins.jdbc.exception.JdbcRuntimeException;
import com.lucidworks.connector.plugins.jdbc.inject.DriversClassLoader;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDataSourceFactory
implements Provider<JdbcDataSource> {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(JdbcDataSourceFactory.class);
    private final JdbcConfig.Properties properties;
    private final DriversClassLoader classloader;

    @Inject
    public JdbcDataSourceFactory(JdbcConfig config, DriversClassLoader classloader) {
        this.properties = config.properties();
        this.classloader = classloader;
    }

    public JdbcDataSource get() {
        logger.info("Loading jdbc drivers");
        try {
            this.classloader.load();
        }
        catch (ClassNotFoundException e) {
            throw JdbcRuntimeException.create(String.format("Driver %s not found in classpath", this.properties.driver()), e);
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(this.properties.url());
        config.setDriverClassName(this.properties.driver());
        config.setMaximumPoolSize(this.properties.maxConnections().intValue());
        if (!Strings.isNullOrEmpty((String)this.properties.username()) && !Strings.isNullOrEmpty((String)this.properties.password())) {
            config.setUsername(this.properties.username());
            config.setPassword(this.properties.password());
        }
        return new JdbcDataSource(new HikariDataSource(config));
    }
}

